<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php
if (!function_exists('esc')) { function esc($s){ return htmlspecialchars((string)($s ?? ''), ENT_QUOTES, 'UTF-8'); } }
$role = $role ?? 'pic';
?>
<style>
  .sig-wrap{max-width:640px;margin:10px auto;padding:16px;border:1px solid #e5e7eb;border-radius:10px;background:#fff}
  .tabs{display:flex;gap:8px;margin-bottom:10px}
  .tabs button{padding:6px 10px;border:1px solid #d1d5db;border-radius:8px;background:#f8fafc;cursor:pointer}
  .tabs button.active{background:#2563eb;color:#fff;border-color:#2563eb}
  .canvas-box{border:1px dashed #9ca3af;border-radius:8px;background:#fff;height:180px;display:flex;align-items:center;justify-content:center}
  canvas{width:100%;height:160px}
  .row{display:flex;gap:10px;align-items:center;margin:8px 0}
  .row label{min-width:120px}
  .actions{display:flex;gap:8px;margin-top:12px}
</style>

<div class="sig-wrap">
  <h3 style="margin:0 0 8px">Tanda Tangan — <?= esc(strtoupper($role)) ?></h3>
  <form method="post" action="<?= site_url('piket-daily/sign/save'); ?>" onsubmit="return submitSig();">
    <input type="hidden" name="piket_id" value="<?= (int)$header->id ?>">
    <input type="hidden" name="role" value="<?= esc($role) ?>">
    <input type="hidden" name="sig_image" id="sig_image">

    <div class="tabs">
      <button type="button" class="active" id="tab-draw">Draw</button>
      <button type="button" id="tab-type">Type</button>
    </div>

    <!-- DRAW -->
    <div id="panel-draw">
      <div class="canvas-box">
        <canvas id="pad" width="600" height="160"></canvas>
      </div>
      <div class="actions">
        <button type="button" onclick="clearPad()">Clear</button>
      </div>
    </div>

    <!-- TYPE -->
    <div id="panel-type" style="display:none">
      <div class="row">
        <label>Nama</label>
        <input type="text" id="typed_name" name="typed_name" class="form-control" style="flex:1" placeholder="Ketik nama">
      </div>
      <small>Jika tidak menggambar, sistem akan menyimpan nama ketikan sebagai signature.</small>
    </div>

    <div class="row">
      <label></label>
      <label><input type="checkbox" required> Saya menyatakan data ini benar.</label>
    </div>

    <div class="actions">
      <button type="submit" class="btn btn-primary">Simpan Tanda Tangan</button>
      <a href="<?= site_url('piket-daily/edit/'.(int)$header->id); ?>" class="btn btn-secondary">Batal</a>
    </div>
  </form>
</div>

<script>
(function(){
  // Tabs
  const tabDraw = document.getElementById('tab-draw');
  const tabType = document.getElementById('tab-type');
  const panelDraw = document.getElementById('panel-draw');
  const panelType = document.getElementById('panel-type');
  tabDraw.onclick = ()=>{ tabDraw.classList.add('active'); tabType.classList.remove('active'); panelDraw.style.display='block'; panelType.style.display='none'; }
  tabType.onclick = ()=>{ tabType.classList.add('active'); tabDraw.classList.remove('active'); panelType.style.display='block'; panelDraw.style.display='none'; }

  // Canvas pad (super simple)
  const cvs = document.getElementById('pad');
  const ctx = cvs.getContext('2d');
  ctx.lineWidth = 2; ctx.lineCap='round'; ctx.strokeStyle='#111827';
  let drawing = false;
  function pos(e){ const r = cvs.getBoundingClientRect(); const x = (e.touches?e.touches[0].clientX:e.clientX)-r.left; const y = (e.touches?e.touches[0].clientY:e.clientY)-r.top; return [x*(cvs.width/r.width), y*(cvs.height/r.height)]; }
  function start(e){ drawing = true; const [x,y]=pos(e); ctx.beginPath(); ctx.moveTo(x,y); e.preventDefault(); }
  function move(e){ if(!drawing) return; const [x,y]=pos(e); ctx.lineTo(x,y); ctx.stroke(); e.preventDefault(); }
  function end(){ drawing=false; }
  cvs.addEventListener('mousedown', start); cvs.addEventListener('mousemove', move); window.addEventListener('mouseup', end);
  cvs.addEventListener('touchstart', start, {passive:false}); cvs.addEventListener('touchmove', move, {passive:false}); cvs.addEventListener('touchend', end);

  window.clearPad = ()=>{ ctx.clearRect(0,0,cvs.width,cvs.height); };

  window.submitSig = ()=>{
    // jika panel draw aktif dan ada coretan, kirim sebagai PNG
    if (panelDraw.style.display !== 'none') {
      // cek apakah canvas kosong
      const blank = document.createElement('canvas'); blank.width=cvs.width; blank.height=cvs.height;
      if (cvs.toDataURL() !== blank.toDataURL()) {
        document.getElementById('sig_image').value = cvs.toDataURL('image/png');
      }
    }
    return true;
  };
})();
</script>
