<?php
  // Segments untuk status menu
  $seg1    = strtolower($this->uri->segment(1) ?: '');
  $seg2    = strtolower($this->uri->segment(2) ?: '');
  $isData  = ($seg1 === 'karyawan');
  $isMold  = in_array($seg1, ['mold','summery_molding'], true);
  $isScan  = ($seg1 === 'scan');
  $isPiket = ($seg1 === 'piket-daily');
?>

<!-- Sidebar -->
<ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion toggled" id="accordionSidebar">
  <!-- NOTE: default tertutup => ada class 'toggled' di <ul>, dan 'sidebar-toggled' di <body> -->

  <!-- Brand -->
  <a class="sidebar-brand d-flex align-items-center justify-content-center" href="<?= base_url('welcome') ?>">
    <div><img src="<?= base_url('assets/img/logo_dhi.png') ?>" alt="Logo" style="height:30px;width:auto;"></div>
    <div class="sidebar-brand-text mx-3">DAE HWA INDONESIA</div>
  </a>

  <!-- Divider -->
  <hr class="sidebar-divider my-0">

  <!-- Dashboard -->
  <li class="nav-item <?= ($seg1 === 'welcome' || $seg1 === '') ? 'active' : '' ?>">
    <a class="nav-link" href="<?= base_url('welcome') ?>">
      <i class="fas fa-fw fa-home"></i><span>Dashboard</span>
    </a>
  </li>

  <!-- DATA -->
  <li class="nav-item <?= $isData ? 'active' : '' ?>">
    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseData"
       aria-expanded="false" aria-controls="collapseData">
      <i class="fas fa-fw fa-cog"></i><span>DATA</span>
    </a>
    <!-- Jangan paksa 'show' supaya tidak popout saat sidebar kecil -->
    <div id="collapseData" class="collapse" data-parent="#accordionSidebar">
      <div class="bg-white py-2 collapse-inner rounded">
        <a class="collapse-item <?= $isData ? 'active' : '' ?>" href="<?= base_url('karyawan') ?>">
          Data Karyawan
        </a>
      </div>
    </div>
  </li>

  <!-- MOLD -->
  <li class="nav-item <?= $isMold ? 'active' : '' ?>">
    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseMold"
       aria-expanded="false" aria-controls="collapseMold">
      <i class="fas fa-cogs"></i><span>MOLD</span>
    </a>
    <div id="collapseMold" class="collapse" data-parent="#accordionSidebar">
      <div class="bg-white py-2 collapse-inner rounded">
        <a class="collapse-item <?= ($seg1 === 'mold') ? 'active' : '' ?>" href="<?= base_url('mold') ?>">
          Transaksi Mold
        </a>
        <a class="collapse-item <?= ($seg1 === 'summery_molding') ? 'active' : '' ?>" href="<?= base_url('summery_molding') ?>">
          Summery Mold
        </a>
      </div>
    </div>
  </li>

  <!-- Scan -->
  <li class="nav-item <?= $isScan ? 'active' : '' ?>">
    <a class="nav-link" href="<?= base_url('scan') ?>">
      <i class="fas fa-qrcode"></i><span>VERIFIKASI SURAT JALAN</span>
    </a>
  </li>

  <!-- PIKET DAILY -->
  <li class="nav-item <?= $isPiket ? 'active' : '' ?>">
    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapsePiket"
       aria-expanded="false" aria-controls="collapsePiket">
      <i class="fas fa-clipboard-check"></i><span>PIKET DAILY</span>
    </a>
    <div id="collapsePiket" class="collapse" data-parent="#accordionSidebar">
      <div class="bg-white py-2 collapse-inner rounded">
        <a class="collapse-item <?= ($isPiket && $seg2 !== 'create') ? 'active' : '' ?>" href="<?= site_url('piket-daily'); ?>">
          List
        </a>
        <a class="collapse-item <?= ($isPiket && $seg2 === 'create') ? 'active' : '' ?>" href="<?= site_url('piket-daily/create'); ?>">
          Entry Baru
        </a>
      </div>
    </div>
  </li>

  <!-- Divider -->
  <hr class="sidebar-divider d-none d-md-block">

  <!-- Sidebar Toggler -->
  <div class="text-center d-none d-md-inline">
    <button class="rounded-circle border-0" id="sidebarToggle"></button>
  </div>
</ul>
<!-- End of Sidebar -->
