<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'auth';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

/* ===========================
   🔑 AUTHENTICATION ROUTES
   =========================== */
$route['auth']                     = 'auth/index';
$route['auth/login']               = 'auth/login';
$route['auth/logout']              = 'auth/logout';
$route['auth/register']            = 'auth/register';
$route['auth/forgot']              = 'auth/forgot_password';
$route['auth/reset']               = 'auth/reset_password';
$route['auth/reset_process']       = 'auth/reset_process';
$route['auth/otp/(:any)']          = 'auth/otp/$1';
$route['auth/otp_process']         = 'auth/otp_process';

/* ===========================
   🧑 ADMIN ROUTES
   =========================== */
$route['admin']                                = 'admin/index';
$route['admin/dashboard']                      = 'admin/index';
$route['admin/data_gesek']                     = 'admin/data_gesek';
$route['admin/form_detail/(:num)']             = 'admin/form_detail/$1';
$route['admin/form/edit/(:num)']               = 'admin/edit_form/$1';
$route['admin/form/update']                    = 'admin/update_form';
$route['admin/delete_form/(:num)']             = 'admin/delete_form/$1';
$route['admin/download_pdf/(:num)']            = 'admin/download_pdf/$1';

/* ===========================
   👤 USER ROUTES
   =========================== */
$route['user']                    = 'user/index';

/* ===========================
   🧾 FORM ROUTES
   =========================== */
$route['form/detail/(:num)']      = 'form/detail/$1';
$route['form/print/(:num)']       = 'form/print/$1';
$route['form/share/(:num)']       = 'form/share/$1';

/* ===========================
   📊 LAPORAN ROUTES
   =========================== */
$route['laporan']                 = 'laporan/index';
$route['laporan/index']           = 'laporan/index';   // ✅ pastikan bisa handle POST & GET
$route['laporan/filter']          = 'laporan/index';   // ✅ tambahan aman buat POST (jaga-jaga form action)
$route['laporan/export']          = 'laporan/export';
$route['laporan/cetak']           = 'laporan/cetak';

/* ===========================
   🔚 END ROUTES
   =========================== */