<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Form_model extends CI_Model {

    /**
     * 🧩 Nama tabel utama
     */
    protected $table = 'form_gesek';

    // =====================================================
    // 📚 GETTER (AMBIL DATA)
    // =====================================================

    /**
     * Ambil semua data form_gesek (urut terbaru)
     */
    public function getAll()
    {
        return $this->db->order_by('id', 'DESC')
                        ->get($this->table)
                        ->result_array();
    }

    /**
     * Ambil satu data berdasarkan ID
     */
    public function getById($id)
    {
        return $this->db->get_where($this->table, ['id' => $id])->row_array();
    }

    /**
     * Ambil data terbaru sejumlah limit
     */
    public function getLatest($limit = 10)
    {
        return $this->db->order_by('id', 'DESC')
                        ->limit($limit)
                        ->get($this->table)
                        ->result_array();
    }

    /**
     * 🔍 Cari data berdasarkan kata kunci (no_pol, tipe, pemilik, noka, nosin)
     */
    public function search($keyword, $limit = null, $offset = null)
    {
        $this->db->from($this->table);
        $this->db->group_start()
                 ->like('no_pol', $keyword)
                 ->or_like('tipe_kendaraan', $keyword)
                 ->or_like('nama_pemilik', $keyword)
                 ->or_like('noka', $keyword)
                 ->or_like('nosin', $keyword)
                 ->group_end()
                 ->order_by('id', 'DESC');

        if (is_numeric($limit) && $limit > 0) {
            $this->db->limit($limit, $offset);
        }

        return $this->db->get()->result_array();
    }

    /**
     * 📅 Ambil data berdasarkan rentang tanggal tgl_gesek
     */
    public function get_by_date($start, $end)
    {
        if (empty($start) || empty($end)) return [];

        $start_sql = date('Y-m-d', strtotime($start));
        $end_sql   = date('Y-m-d', strtotime($end));

        $this->db->from($this->table);
        $this->db->where('tgl_gesek >=', $start_sql);
        $this->db->where('tgl_gesek <=', $end_sql);
        $this->db->order_by('tgl_gesek', 'ASC');

        log_message('debug', "Form_model::get_by_date() => {$start_sql} s.d {$end_sql}");

        return $this->db->get()->result_array();
    }

    /**
     * Cek apakah nomor polisi sudah ada
     */
    public function existsNoPol($no_pol)
    {
        return $this->db->where('no_pol', $no_pol)
                        ->get($this->table)
                        ->num_rows() > 0;
    }

    // =====================================================
    // ✏️ MUTATOR (TAMBAH / EDIT / HAPUS)
    // =====================================================

    /**
     * Tambah data baru ke form_gesek
     */
    public function insert($data)
    {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }

    /**
     * Update data berdasarkan ID
     */
    public function update($id, $data)
    {
        return $this->db->where('id', $id)
                        ->update($this->table, $data);
    }

    /**
     * Hapus data berdasarkan ID
     */
    public function delete($id)
    {
        return $this->db->where('id', $id)
                        ->delete($this->table);
    }
}
