<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User_model extends CI_Model {

    private $table = "users";

    public function getByEmail($email) {
        return $this->db->get_where($this->table, ['email' => $email])->row_array();
    }

    public function register($data) {
        return $this->db->insert($this->table, $data);
    }

    public function updatePassword($email, $new_password) {
        $this->db->where('email', $email);
        return $this->db->update($this->table, ['password' => $new_password]);
    }

    public function getAll()
{
    return $this->db->get('users')->result_array();
}

public function getById($id)
{
    return $this->db->get_where('users', ['id' => $id])->row_array();
}

public function insert($data)
{
    return $this->db->insert('users', $data);
}

public function update($id, $data)
{
    return $this->db->where('id', $id)->update('users', $data);
}

public function delete($id)
{
    return $this->db->delete('users', ['id' => $id]);
}

}
