<div class="container-fluid">

    <!-- Judul -->
    <h1 class="h3 mb-4 text-gray-800">Dashboard Admin</h1>

    <!-- Ringkasan -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Petugas</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $total_user; ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-friends fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Total Form</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $total_form; ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Input Hari Ini</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $total_hari_ini; ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar-day fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Input Bulan Ini</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $total_bulan_ini; ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Grafik -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Statistik Form Gesek per Bulan</h6>
        </div>
        <div class="card-body">
            <canvas id="chartForm"></canvas>
        </div>
    </div>

    <!-- Data terbaru -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-success">10 Data Terbaru</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>No Polisi</th>
                            <th>Tipe</th>
                            <th>Nama Pemilik</th>
                            <th>Petugas</th>
                            <th>Tanggal Gesek</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($latest_forms as $f): ?>
                        <tr>
                            <td><?= $f['no_pol']; ?></td>
                            <td><?= $f['tipe_kendaraan']; ?></td>
                            <td><?= $f['nama_pemilik']; ?></td>
                            <td><?= $f['petugas']; ?></td>
                            <td><?= date('d/m/Y', strtotime($f['tgl_gesek'])); ?></td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($latest_forms)): ?>
                        <tr><td colspan="5" class="text-center text-muted">Belum ada data</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<!-- ChartJS -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const ctx = document.getElementById('chartForm');
new Chart(ctx, {
    type: 'bar',
    data: {
        labels: <?= $bulan_labels; ?>,
        datasets: [{
            label: 'Total Form',
            data: <?= $bulan_values; ?>,
            backgroundColor: 'rgba(78, 115, 223, 0.6)',
            borderColor: 'rgba(78, 115, 223, 1)',
            borderWidth: 1
        }]
    },
    options: {
        scales: {
            y: { beginAtZero: true }
        }
    }
});
</script>
