<div class="container-fluid">

  <!-- Judul -->
  <h1 class="h3 mb-4 text-gray-800">Manajemen Data Gesek</h1>

  <!-- 🔍 Pencarian -->
  <form class="form-inline mb-3" method="get" action="<?= base_url('admin/data_gesek'); ?>">
    <input type="text" name="keyword" class="form-control mr-2"
           placeholder="Cari No. Polisi / Pemilik / Tipe / NOKA / NOSIN..."
           value="<?= $keyword; ?>">
    <button type="submit" class="btn btn-primary">
      <i class="fas fa-search"></i> Cari
    </button>
    <?php if (!empty($keyword)): ?>
      <a href="<?= base_url('admin/data_gesek'); ?>" class="btn btn-secondary ml-2">Reset</a>
    <?php endif; ?>
  </form>

  <!-- Tombol Tambah (Hanya Admin) -->
  <?php if (!empty($can_write) && $can_write): ?>
    <a href="<?= base_url('form/add'); ?>" class="btn btn-success mb-3">
      <i class="fas fa-plus-circle"></i> Tambah Data
    </a>
  <?php endif; ?>

  <!-- ======== 💻 DESKTOP MODE ======== -->
  <div class="card shadow mb-4 d-none d-md-block">
    <div class="card-body table-responsive">
      <table class="table table-bordered table-hover">
        <thead class="bg-primary text-white text-center">
          <tr>
            <th width="40">No</th>
            <th>No Polisi</th>
            <th>Tipe Kendaraan</th>
            <th>Nama Pemilik</th>
            <th>Tgl Gesek</th>
            <th>Petugas</th>
            <th width="200">Aksi</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($forms)): ?>
            <?php $no = 1; foreach ($forms as $f): ?>
              <tr>
                <td class="text-center"><?= $no++; ?></td>
                <td class="font-weight-bold text-primary"><?= strtoupper($f['no_pol']); ?></td>
                <td><?= strtoupper($f['tipe_kendaraan']); ?></td>
                <td><?= strtoupper($f['nama_pemilik']); ?></td>
                <td class="text-center"><?= date('d/m/Y', strtotime($f['tgl_gesek'])); ?></td>
                <td class="text-uppercase"><?= $f['petugas']; ?></td>
                <td class="text-center">
                  <div class="btn-group" role="group">
                    <!-- View -->
                    <a href="<?= base_url('admin/form_detail/'.$f['id']); ?>" class="btn btn-sm btn-info" title="Lihat">
                      <i class="fas fa-eye"></i>
                    </a>

                    <!-- Print -->
                    <a href="<?= base_url('form/print/'.$f['id']); ?>" target="_blank" class="btn btn-sm btn-secondary" title="Print">
                      <i class="fas fa-print"></i>
                    </a>

                    <!-- Download -->
                    <a href="<?= base_url('admin/download_pdf/'.$f['id']); ?>" class="btn btn-sm btn-success" title="Download">
                      <i class="fas fa-download"></i>
                    </a>

                    <!-- Edit & Hapus hanya admin -->
                    <?php if (!empty($can_write) && $can_write): ?>
                      <a href="<?= base_url('admin/edit_form/'.$f['id']); ?>" class="btn btn-sm btn-warning" title="Edit">
                        <i class="fas fa-edit"></i>
                      </a>
                      <a href="<?= base_url('admin/delete_form/'.$f['id']); ?>"
                         class="btn btn-sm btn-danger btn-delete"
                         title="Hapus"
                         onclick="return confirm('Yakin ingin menghapus data ini?');">
                        <i class="fas fa-trash "></i>
                      </a>
                    <?php endif; ?>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr>
              <td colspan="7" class="text-center text-muted">Tidak ada data ditemukan.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- ======== 📱 MOBILE MODE ======== -->
  <div class="d-md-none">
    <?php if (!empty($forms)): ?>
      <?php foreach ($forms as $f): ?>
        <div class="card shadow-sm mb-3 border-left-primary animated--fade-in">
          <div class="card-body py-2">

            <!-- Header -->
            <div class="d-flex justify-content-between align-items-center mb-2">
              <h6 class="font-weight-bold text-primary mb-0"><?= strtoupper($f['no_pol']); ?></h6>
              <small class="text-muted"><?= strtoupper($f['pool']); ?></small>
            </div>

            <!-- Detail Kendaraan -->
            <div class="text-gray-800 small mb-2">
              <strong><?= strtoupper($f['tipe_kendaraan']); ?></strong> • <?= strtoupper($f['nama_pemilik']); ?>
            </div>

            <div class="small text-gray-600 mb-1">
              <i class="fas fa-barcode"></i> <span class="text-uppercase"><?= $f['noka'] ?: '-'; ?></span>
            </div>
            <div class="small text-gray-600 mb-2">
              <i class="fas fa-cog"></i> <span class="text-uppercase"><?= $f['nosin'] ?: '-'; ?></span>
            </div>

            <!-- Info tanggal & petugas -->
            <div class="small mb-2">
              <i class="fas fa-calendar-day text-success"></i>
              <?= date('d/m/Y', strtotime($f['tgl_gesek'])); ?>
            </div>
            <div class="small mb-3">
              <i class="fas fa-user text-secondary"></i> <?= strtoupper($f['petugas']); ?>
            </div>

            <!-- Tombol Aksi -->
            <div class="d-flex justify-content-end flex-wrap gap-2">
              <a href="<?= base_url('admin/form_detail/'.$f['id']); ?>" class="btn btn-sm btn-info mr-1 mb-1">
                <i class="fas fa-eye"></i> View
              </a>
              <a href="<?= base_url('form/print/'.$f['id']); ?>" target="_blank" class="btn btn-sm btn-secondary mr-1 mb-1">
                <i class="fas fa-print"></i> Print
              </a>
              <a href="<?= base_url('admin/download_pdf/'.$f['id']); ?>" class="btn btn-sm btn-success mr-1 mb-1">
                <i class="fas fa-download"></i> Download
              </a>

              <?php if (!empty($can_write) && $can_write): ?>
                <a href="<?= base_url('admin/edit_form/'.$f['id']); ?>" class="btn btn-sm btn-warning mr-1 mb-1">
                  <i class="fas fa-edit"></i> Edit
                </a>
                <a href="<?= base_url('admin/delete_form/'.$f['id']); ?>" class="btn btn-sm btn-danger mb-1"
                   onclick="return confirm('Yakin ingin menghapus data ini?');">
                  <i class="fas fa-trash"></i> Hapus
                </a>
              <?php endif; ?>
            </div>

          </div>
        </div>
      <?php endforeach; ?>
    <?php else: ?>
      <div class="alert alert-light text-center">Belum ada data.</div>
    <?php endif; ?>
  </div>

</div>

<style>
/* ====== SMOOTH CARD ANIMATION ====== */
.animated--fade-in {
  animation: fadeIn 0.3s ease-in-out;
}
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(5px); }
  to { opacity: 1; transform: translateY(0); }
}
</style>
