<div class="card shadow mb-4">
  <div class="card-header py-3">
    <h6 class="m-0 font-weight-bold text-success">Edit Data Gesek</h6>
  </div>

  <div class="card-body">
    <form action="<?= base_url('admin/update_form'); ?>" method="POST" enctype="multipart/form-data">
      <input type="hidden" name="id" value="<?= $form['id']; ?>">

      <!-- =====================
           DATA KENDARAAN
      ====================== -->
      <h6 class="font-weight-bold text-primary mb-2">Data Kendaraan</h6>

      <div class="form-group">
        <label>Nomor Polisi *</label>
        <input type="text" name="no_pol" class="form-control text-uppercase"
               value="<?= $form['no_pol']; ?>" required>
      </div>

      <div class="form-group">
        <label>Tipe Kendaraan *</label>
        <input type="text" name="tipe_kendaraan" class="form-control text-uppercase"
               value="<?= $form['tipe_kendaraan']; ?>" required>
      </div>

      <div class="form-group">
        <label>Nama Pemilik</label>
        <input type="text" name="nama_pemilik" class="form-control text-uppercase"
               value="<?= $form['nama_pemilik']; ?>">
      </div>

      <div class="form-group">
        <label for="pool">Pool *</label>
        <select name="pool" id="pool" class="form-control text-uppercase" required>
          <option value="">-- Pilih Pool --</option>
          <option value="PEKAYON" <?= $form['pool']=='PEKAYON'?'selected':''; ?>>PEKAYON</option>
          <option value="CIKUNIR" <?= $form['pool']=='CIKUNIR'?'selected':''; ?>>CIKUNIR</option>
        </select>
      </div>

      <hr>
      <!-- =====================
           DATA TANGGAL
      ====================== -->
      <h6 class="font-weight-bold text-primary mb-2">Data Tanggal</h6>

      <div class="form-group">
        <label>Tanggal In Pool</label>
        <input type="date" name="tgl_inpool" class="form-control"
               value="<?= $form['tgl_inpool']; ?>">
      </div>

      <div class="form-group">
        <label>Tanggal Gesek *</label>
        <input type="date" name="tgl_gesek" class="form-control"
               value="<?= $form['tgl_gesek']; ?>" required>
      </div>

      <hr>
      <!-- =====================
           DATA TEKNIS
      ====================== -->
      <h6 class="font-weight-bold text-primary mb-2">Data Teknis</h6>

      <div class="form-group">
        <label>Nomor Rangka (NOKA)</label>
        <input type="text" name="noka" class="form-control text-uppercase"
               value="<?= $form['noka']; ?>">
      </div>

      <div class="form-group">
        <label>Nomor Mesin (NOSIN)</label>
        <input type="text" name="nosin" class="form-control text-uppercase"
               value="<?= $form['nosin']; ?>">
      </div>

      <hr>
      <!-- =====================
           KETERANGAN
      ====================== -->
      <h6 class="font-weight-bold text-primary mb-2">Keterangan</h6>

      <?php 
        $options = [
          'NOSIN KARAT','NOSIN KARAT & RUSAK','NOSIN TIDAK TERJANGKAU',
          'NOKA KARAT','NOKA KARAT & RUSAK','NOKA TIDAK TERJANGKAU'
        ];
        $selected_opts = explode(',', $form['keterangan_check'] ?? '');
      ?>
      <div class="form-group">
        <?php foreach ($options as $opt): ?>
          <div class="form-check">
            <input class="form-check-input" type="checkbox"
                   name="keterangan_check[]" value="<?= $opt; ?>"
                   id="<?= $opt; ?>"
                   <?= in_array($opt,$selected_opts)?'checked':''; ?>>
            <label class="form-check-label" for="<?= $opt; ?>"><?= $opt; ?></label>
          </div>
        <?php endforeach; ?>
      </div>

      <div class="form-group mt-2">
        <label>Keterangan Lain (Opsional)</label>
        <textarea name="keterangan" class="form-control text-uppercase" rows="3"><?= $form['keterangan']; ?></textarea>
      </div>

      <hr>
      <!-- =====================
           UPLOAD FOTO
      ====================== -->
      <h6 class="font-weight-bold text-primary mb-3">Upload Foto (Opsional)</h6>

      <div class="upload-wrapper">
        
       <!-- Foto Noka Nosin -->
<div class="upload-item">
  <label for="foto_noka_nosin">Foto Noka Nosin</label>
  <button type="button" class="upload-btn" onclick="document.getElementById('foto_noka_nosin').click()">
    <i class="fas fa-camera"></i>
  </button>
  <input type="file" name="foto_noka_nosin" id="foto_noka_nosin" accept="image/*"
         onchange="handleImageUpload(this, 'preview_noka_nosin')">
</div>
<?php if (!empty($form['foto_noka_nosin']) && file_exists(FCPATH.'assets/uploads/'.$form['foto_noka_nosin'])): ?>
  <img id="preview_noka_nosin" src="<?= base_url('assets/uploads/'.$form['foto_noka_nosin']); ?>" class="img-preview">
<?php else: ?>
  <img id="preview_noka_nosin" src="#" class="img-preview d-none">
<?php endif; ?>


<!-- Foto Nomor Rangka -->
<div class="upload-item">
  <label for="foto_noka">Foto Nomor Rangka</label>
  <button type="button" class="upload-btn" onclick="document.getElementById('foto_noka').click()">
    <i class="fas fa-camera"></i>
  </button>
  <input type="file" name="foto_noka" id="foto_noka" accept="image/*"
         onchange="handleImageUpload(this, 'preview_noka')">
</div>
<?php if (!empty($form['foto_noka']) && file_exists(FCPATH.'assets/uploads/'.$form['foto_noka'])): ?>
  <img id="preview_noka" src="<?= base_url('assets/uploads/'.$form['foto_noka']); ?>" class="img-preview">
<?php else: ?>
  <img id="preview_noka" src="#" class="img-preview d-none">
<?php endif; ?>


<!-- Foto Nomor Mesin -->
<div class="upload-item">
  <label for="foto_nosin">Foto Nomor Mesin</label>
  <button type="button" class="upload-btn" onclick="document.getElementById('foto_nosin').click()">
    <i class="fas fa-camera"></i>
  </button>
  <input type="file" name="foto_nosin" id="foto_nosin" accept="image/*"
         onchange="handleImageUpload(this, 'preview_nosin')">
</div>
<?php if (!empty($form['foto_nosin']) && file_exists(FCPATH.'assets/uploads/'.$form['foto_nosin'])): ?>
  <img id="preview_nosin" src="<?= base_url('assets/uploads/'.$form['foto_nosin']); ?>" class="img-preview">
<?php else: ?>
  <img id="preview_nosin" src="#" class="img-preview d-none">
<?php endif; ?>


      <hr>
      <!-- =====================
           PETUGAS
      ====================== -->
      <div class="form-group">
        <label>Nama Petugas</label>
        <input type="text" readonly class="form-control" value="<?= $form['petugas']; ?>">
      </div>

      <div class="text-right mt-3">
        <a href="<?= base_url('admin/data_gesek'); ?>" class="btn btn-secondary">Batal</a>
        <button type="submit" class="btn btn-success">Simpan Perubahan</button>
      </div>
    </form>
  </div>
</div>

<!-- =====================
     🎨 STYLING
===================== -->
<style>
.upload-wrapper {
  display: flex;
  flex-direction: column;
  gap: 12px;
}
.upload-item {
  display: flex;
  align-items: center;
  justify-content: space-between;
  border: 1px dashed #ccc;
  border-radius: 8px;
  padding: 10px 14px;
  background: #f9f9f9;
  transition: all 0.2s ease;
}
.upload-item:hover {
  background: #eefbf2;
  border-color: #28a745;
}
.upload-item label {
  font-weight: 600;
  color: #333;
  margin: 0;
}
.upload-btn {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  background: #28a745;
  color: white;
  border: none;
  border-radius: 50%;
  width: 38px;
  height: 38px;
  cursor: pointer;
  transition: 0.2s;
}
.upload-btn:hover {
  background: #218838;
}
.upload-btn i {
  font-size: 16px;
}
input[type="file"] { display: none; }

.img-preview {
  display: block;
  margin: 8px auto 12px auto;
  border: 2px solid #e9ecef;
  border-radius: 10px;
  object-fit: contain;
  max-width: 100%;
  height: auto;
}
</style>
