<div class="container-fluid animated--fade-in">

  <!-- Judul -->
  <h1 class="h3 mb-4 text-gray-800"><i class="fas fa-user-edit"></i> Edit Data User</h1>

  <!-- Card -->
  <div class="card shadow border-0">
    <div class="card-body">

      <form action="<?= base_url('admin/user_update/'.$user['id']); ?>" method="post" class="needs-validation" novalidate>

        <!-- Nama Lengkap -->
        <div class="form-group">
          <label class="font-weight-bold text-gray-700">Nama Lengkap <span class="text-danger">*</span></label>
          <input type="text" name="name" class="form-control" required
                 value="<?= htmlspecialchars($user['name']); ?>"
                 placeholder="Masukkan nama lengkap">
          <div class="invalid-feedback">Nama wajib diisi.</div>
        </div>

        <!-- Email -->
        <div class="form-group">
          <label class="font-weight-bold text-gray-700">Email <span class="text-danger">*</span></label>
          <input type="email" name="email" class="form-control" required
                 value="<?= htmlspecialchars($user['email']); ?>"
                 placeholder="Masukkan email aktif">
          <div class="invalid-feedback">Email wajib diisi.</div>
        </div>

        <!-- Role -->
        <div class="form-group">
          <label class="font-weight-bold text-gray-700">Role <span class="text-danger">*</span></label>
          <select name="role" class="form-control" required>
            <option value="">-- Pilih Role --</option>
            <option value="user" <?= $user['role']=='user'?'selected':''; ?>>User / Petugas</option>
            <option value="admin" <?= $user['role']=='admin'?'selected':''; ?>>Admin</option>
            <option value="inspector" <?= $user['role']=='inspector'?'selected':''; ?>>Inspector</option>
          </select>
          <div class="invalid-feedback">Role wajib dipilih.</div>
        </div>

        <!-- Status -->
        <div class="form-group">
          <label class="font-weight-bold text-gray-700">Status</label>
          <select name="status" class="form-control">
            <option value="1" <?= $user['status']==1?'selected':''; ?>>Aktif</option>
            <option value="0" <?= $user['status']==0?'selected':''; ?>>Nonaktif</option>
          </select>
        </div>

        <!-- Reset Password (opsional) -->
        <div class="form-group">
          <label class="font-weight-bold text-gray-700">Reset Password (Opsional)</label>
          <input type="password" name="password" class="form-control"
                 placeholder="Isi jika ingin ubah password">
          <small class="form-text text-muted">
            Kosongkan jika tidak ingin mengubah password.
          </small>
        </div>

        <!-- Tombol -->
        <div class="text-right">
          <a href="<?= base_url('admin/users'); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Batal
          </a>
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Simpan Perubahan
          </button>
        </div>

      </form>
    </div>
  </div>
</div>

<!-- JS Validation -->
<script>
(function() {
  'use strict';
  window.addEventListener('load', function() {
    var forms = document.getElementsByClassName('needs-validation');
    Array.prototype.filter.call(forms, function(form) {
      form.addEventListener('submit', function(event) {
        if (form.checkValidity() === false) {
          event.preventDefault();
          event.stopPropagation();
          Swal.fire('Oops!', 'Lengkapi semua field wajib.', 'warning');
        }
        form.classList.add('was-validated');
      }, false);
    });
  }, false);
})();
</script>

<style>
/* Animasi lembut & responsive */
.animated--fade-in { animation: fadeIn 0.3s ease-in-out; }
@keyframes fadeIn { from {opacity:0; transform:translateY(6px);} to {opacity:1; transform:none;} }

.card { border-radius: 1rem; }
label { font-size: 0.95rem; }
.form-control { border-radius: 0.5rem; }
.btn { border-radius: 0.5rem; }
</style>
