<!DOCTYPE html>
<html lang="en">
<head>
    <?php $this->load->view('partials/header'); ?>

    <!-- 🔧 Local style kecil khusus layout global -->
    <style>
      /* Back to Top (global floating) */
      #backToTop {
        position: fixed !important;
        right: 16px;
        bottom: 18px;
        width: 48px; height: 48px;
        border-radius: 50%;
        display: none;                 /* toggle via .show */
        align-items: center; justify-content: center;
        z-index: 3000;                 /* di atas footer/topbar/overlay biasa */
        box-shadow: 0 6px 18px rgba(0,0,0,.15);
        background: #198754; color: #fff; border: 0; cursor: pointer;
      }
      #backToTop i { font-size: 18px; line-height: 1; }
      #backToTop.show { display: inline-flex; }
      #backToTop:active { transform: translateY(1px); }

      /* Optional: jaga footer nempel bawah saat konten sedikit */
      #content-wrapper { min-height: 100vh; }
      /* Hilangkan margin ekstra default container di beberapa halaman */
      .page-content-no-wrapper { padding-left: 0; padding-right: 0; }
    </style>
</head>

<body id="page-top">
    <!-- Skip link untuk aksesibilitas -->
    <a href="#main-content" class="sr-only sr-only-focusable">Skip to main content</a>

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php $this->load->view('partials/sidebar'); ?>

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <?php $this->load->view('partials/topbar'); ?>

                <!-- Begin Page Content -->
                <!-- ⚠️ Tidak dibungkus container-fluid di sini,
                     biar setiap view bisa atur layout-nya sendiri (hindari double-padding). -->
                <main id="main-content" role="main">
                    <?php $this->load->view($content); ?>
                </main>
                <!-- End Page Content -->

            </div>
            <!-- End Main Content -->

            <!-- Footer -->
            <?php $this->load->view('partials/footer'); ?>

        </div>
        <!-- End Content Wrapper -->
    </div>
    <!-- End Page Wrapper -->

    <!-- Scripts global -->
    <?php $this->load->view('partials/script'); ?>

    <!-- ⬆️ Back to Top (global, di semua halaman) -->
    <button id="backToTop" type="button" aria-label="Kembali ke atas">
        <i class="fas fa-arrow-up"></i>
    </button>

    <script>
    (function() {
      // Inisialisasi tooltip kalau Bootstrap 4 tersedia (SB Admin 2)
      if (typeof $ !== 'undefined' && typeof $.fn.tooltip === 'function') {
        $('[data-toggle="tooltip"]').tooltip({ boundary: 'window' });
      }

      // Back to Top behavior
      var backBtn = document.getElementById('backToTop');
      if (backBtn) {
        var toggleBackBtn = function() {
          if (window.pageYOffset > 240) {
            backBtn.classList.add('show');
          } else {
            backBtn.classList.remove('show');
          }
        };
        window.addEventListener('scroll', toggleBackBtn, { passive: true });
        toggleBackBtn();

        backBtn.addEventListener('click', function() {
          window.scrollTo({ top: 0, behavior: 'smooth' });
        });
      }
    })();
    </script>

    <!-- SweetAlert (pakai json_encode biar aman dari karakter spesial) -->
    <?php if ($this->session->flashdata('error')): ?>
    <script>
      Swal.fire({
        icon: 'error',
        title: 'Duplikasi Data!',
        text: <?= json_encode($this->session->flashdata('error')); ?>,
        confirmButtonColor: '#3085d6'
      });
    </script>
    <?php endif; ?>

    <?php if ($this->session->flashdata('success')): ?>
    <script>
      Swal.fire({
        icon: 'success',
        title: 'Sukses!',
        text: <?= json_encode($this->session->flashdata('success')); ?>,
        confirmButtonColor: '#28a745'
      });
    </script>
    <?php endif; ?>

    <noscript>
      <div class="alert alert-warning m-3" role="alert">
        JavaScript dinonaktifkan. Beberapa fitur (mis. tombol kembali ke atas, tooltip) mungkin tidak berfungsi.
      </div>
    </noscript>
</body>
</html>
