<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h4 mb-0 text-gray-800">Dashboard User</h1>
    </div>

    <!-- Welcome Card -->
    <div class="card shadow mb-4 border-left-success">
        <div class="card-body">
            <h5 class="text-success mb-1">Selamat Datang,</h5>
            <h4 class="font-weight-bold text-dark"><?= strtoupper($this->session->userdata('name')); ?></h4>
            <p class="mb-0 text-muted">Selamat bekerja, semoga produktif hari ini!</p>
        </div>
    </div>

    <!-- Statistik Section -->
    <div class="row">

        <!-- Input Hari Ini -->
        <div class="col-xl-6 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Input Hari Ini
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?= isset($input_hari_ini) ? $input_hari_ini : 0; ?>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar-day fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Bulan Ini -->
        <div class="col-xl-6 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Bulan Ini
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?= isset($total_bulan_ini) ? $total_bulan_ini : 0; ?>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- Aksi Cepat -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-success">Aksi Cepat</h6>
        </div>
        <div class="card-body text-center">
            <a href="<?= base_url('form/add'); ?>" class="btn btn-success btn-icon-split shadow-sm">
                <span class="icon text-white-50">
                    <i class="fas fa-plus"></i>
                </span>
                <span class="text">Tambah Form Gesek</span>
            </a>
        </div>
    </div>

    <!-- Data Terbaru -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Data Terbaru</h6>
        </div>
        <div class="card-body">

            <?php if (!empty($latest_forms)): ?>
                <?php foreach ($latest_forms as $f): ?>
                    <div class="d-flex justify-content-between align-items-center border rounded p-3 mb-2">
                        <div>
                            <a href="<?= base_url('form/detail/'.$f['id']); ?>" 
                               class="font-weight-bold text-success h6 mb-0 d-block text-uppercase">
                                <?= $f['no_pol']; ?>
                            </a>
                            <small class="text-dark d-block"><?= $f['tipe_kendaraan']; ?> - <?= $f['nama_pemilik']; ?></small>
                            <small class="text-muted">
                                <?= date('d M Y', strtotime($f['tgl_gesek'])); ?>
                            </small>
                        </div>
                        <a href="<?= base_url('form/detail/'.$f['id']); ?>" class="btn btn-outline-success btn-sm">
                            <i class="fas fa-eye"></i> Detail
                        </a>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="alert alert-light text-center mb-0">
                    Belum ada data form gesek yang diinput.
                </div>
            <?php endif; ?>

        </div>
    </div>

</div>
