<div class="card shadow mb-4">
  <div class="card-header py-3">
    <h6 class="m-0 font-weight-bold text-success">Form Input Gesek</h6>
  </div>

  <div class="card-body">
    <form action="<?= base_url('form/save'); ?>" method="POST" enctype="multipart/form-data">

      <!-- =====================
           DATA KENDARAAN
      ====================== -->
      <h6 class="font-weight-bold text-primary mb-2">Data Kendaraan</h6>

      <div class="form-group">
        <label>Nomor Polisi *</label>
        <input type="text" name="no_pol" class="form-control text-uppercase" placeholder="B 1234 CDF" required>
      </div>

      <div class="form-group">
        <label>Tipe Kendaraan *</label>
        <input type="text" name="tipe_kendaraan" class="form-control text-uppercase" placeholder="Avanza, Xenia, dll" required>
      </div>

      <div class="form-group">
        <label>Nama Pemilik</label>
        <input type="text" name="nama_pemilik" class="form-control text-uppercase" placeholder="Nama pemilik kendaraan">
      </div>

      <div class="form-group">
        <label for="pool">Pool *</label>
        <select name="pool" id="pool" class="form-control text-uppercase" required>
          <option value="">-- Pilih Pool --</option>
          <option value="PEKAYON" <?= set_select('pool', 'PEKAYON'); ?>>PEKAYON</option>
          <option value="CIKUNIR" <?= set_select('pool', 'CIKUNIR'); ?>>CIKUNIR</option>
        </select>
      </div>

      <hr>
      <!-- =====================
           DATA TANGGAL
      ====================== -->
      <h6 class="font-weight-bold text-primary mb-2">Data Tanggal</h6>

      <div class="form-group">
        <label>Tanggal In Pool</label>
        <input type="date" name="tgl_inpool" class="form-control">
      </div>

      <div class="form-group">
        <label>Tanggal Gesek *</label>
        <input type="date" name="tgl_gesek" class="form-control" required>
      </div>

      <hr>
      <!-- =====================
           DATA TEKNIS
      ====================== -->
      <h6 class="font-weight-bold text-primary mb-2">Data Teknis</h6>

      <div class="form-group">
        <label>Nomor Rangka (NOKA)</label>
        <input type="text" name="noka" class="form-control text-uppercase" placeholder="Nomor rangka kendaraan">
      </div>

      <div class="form-group">
        <label>Nomor Mesin (NOSIN)</label>
        <input type="text" name="nosin" class="form-control text-uppercase" placeholder="Nomor mesin kendaraan">
      </div>

      <hr>
      <!-- =====================
           KETERANGAN
      ====================== -->
      <h6 class="font-weight-bold text-primary mb-2">Keterangan</h6>

      <div class="form-group">
        <label>Pilih Keterangan Kendaraan</label><br>
        <?php 
          $options = [
            'NOSIN KARAT', 
            'NOSIN KARAT & RUSAK', 
            'NOSIN TIDAK TERJANGKAU', 
            'NOKA KARAT', 
            'NOKA KARAT & RUSAK', 
            'NOKA TIDAK TERJANGKAU'
          ];
          foreach ($options as $opt): ?>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="keterangan_check[]" value="<?= $opt; ?>" id="<?= $opt; ?>">
            <label class="form-check-label" for="<?= $opt; ?>"><?= $opt; ?></label>
          </div>
        <?php endforeach; ?>
      </div>

      <div class="form-group mt-2">
        <label>Keterangan Lain (Opsional)</label>
        <textarea name="keterangan" class="form-control text-uppercase" rows="3" placeholder="KETERANGAN TAMBAHAN JIKA DIPERLUKAN"></textarea>
      </div>

      <hr>
      
<!-- =====================
     UPLOAD FOTO
====================== -->
<h6 class="font-weight-bold text-primary mb-3">Upload Foto (Opsional)</h6>

<div class="upload-wrapper">

  <!-- Foto Noka Nosin -->
  <div class="upload-item">
    <label class="mb-0">Foto Noka Nosin</label>
    <div class="btn-group">
      <button type="button" class="upload-btn" title="Kamera"
              onclick="openPicker('foto_noka_nosin','camera')">
        <i class="fas fa-camera"></i>
      </button>
      <button type="button" class="upload-btn alt" title="Galeri"
              onclick="openPicker('foto_noka_nosin','gallery')">
        <i class="fas fa-image"></i>
      </button>
    </div>
    <input type="file" name="foto_noka_nosin" id="foto_noka_nosin"
           accept="image/*"
           onchange="handleImageUpload(this, 'preview_noka_nosin')"
           style="display:none;">
  </div>
  <img id="preview_noka_nosin" src="#" alt="Preview Foto Noka Nosin" class="img-preview d-none">

  <!-- Foto Nomor Rangka -->
  <div class="upload-item">
    <label class="mb-0">Foto Nomor Rangka</label>
    <div class="btn-group">
      <button type="button" class="upload-btn" title="Kamera"
              onclick="openPicker('foto_noka','camera')">
        <i class="fas fa-camera"></i>
      </button>
      <button type="button" class="upload-btn alt" title="Galeri"
              onclick="openPicker('foto_noka','gallery')">
        <i class="fas fa-image"></i>
      </button>
    </div>
    <input type="file" name="foto_noka" id="foto_noka"
           accept="image/*"
           onchange="handleImageUpload(this, 'preview_noka')"
           style="display:none;">
  </div>
  <img id="preview_noka" src="#" alt="Preview Foto Nomor Rangka" class="img-preview d-none">

  <!-- Foto Nomor Mesin -->
  <div class="upload-item">
    <label class="mb-0">Foto Nomor Mesin</label>
    <div class="btn-group">
      <button type="button" class="upload-btn" title="Kamera"
              onclick="openPicker('foto_nosin','camera')">
        <i class="fas fa-camera"></i>
      </button>
      <button type="button" class="upload-btn alt" title="Galeri"
              onclick="openPicker('foto_nosin','gallery')">
        <i class="fas fa-image"></i>
      </button>
    </div>
    <input type="file" name="foto_nosin" id="foto_nosin"
           accept="image/*"
           onchange="handleImageUpload(this, 'preview_nosin')"
           style="display:none;">
  </div>
  <img id="preview_nosin" src="#" alt="Preview Foto Nomor Mesin" class="img-preview d-none">

</div>

      <hr>
      <!-- =====================
           PETUGAS
      ====================== -->
      <div class="form-group">
        <label>Nama Petugas</label>
        <input type="text" readonly class="form-control" value="<?= $this->session->userdata('name'); ?>">
      </div>

      <div class="text-right mt-3">
        <a href="<?= base_url('form'); ?>" class="btn btn-secondary">Batal</a>
        <button type="submit" class="btn btn-success">Simpan Data</button>
      </div>

    </form>
  </div>
</div>

<style>
/* === Wrapper keseluruhan upload section === */
.upload-wrapper {
  display: flex;
  flex-direction: column;
  gap: 16px;
  margin-top: 10px;
}

/* === Kotak upload === */
.upload-item {
  display: flex;
  align-items: center;
  justify-content: space-between;
  border: 2px dashed #cce3d1;
  border-radius: 12px;
  padding: 10px 14px;
  background: #fbfefb;
  transition: all 0.25s ease-in-out;
}
.upload-item:hover {
  background: #f0fff5;
  border-color: #28a745;
  box-shadow: 0 2px 8px rgba(40, 167, 69, 0.15);
}

.upload-item label {
  font-weight: 600;
  color: #2e4832;
  margin: 0;
  font-size: 0.95rem;
}

/* === Tombol upload (kamera & galeri satu warna hijau) === */
.btn-group {
  display: flex;
  gap: 8px;
}

.upload-btn {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  border: none;
  border-radius: 50%;
  width: 44px;
  height: 44px;
  color: #fff;
  font-size: 18px;
  cursor: pointer;
  transition: all 0.25s ease;
  box-shadow: 0 3px 6px rgba(0,0,0,0.15);
  background: linear-gradient(135deg, #4cd964, #28a745);
}
.upload-btn:hover {
  background: linear-gradient(135deg, #28a745, #1e7e34);
  transform: scale(1.1);
  box-shadow: 0 4px 12px rgba(40, 167, 69, 0.3);
}

.upload-btn:active {
  transform: scale(0.96);
  background: linear-gradient(135deg, #1e7e34, #28a745);
}

.upload-btn i {
  color: #fff;
  text-shadow: 0 1px 3px rgba(0,0,0,0.25);
}

/* file input disembunyikan */
input[type="file"] {
  display: none;
}

/* preview gambar */
.img-preview {
  display: block;
  margin: 10px auto;
  border: 2px solid #e9ecef;
  border-radius: 12px;
  object-fit: contain;
  max-width: 100%;
  height: auto;
  background: #fff;
  padding: 4px;
  transition: transform 0.2s ease, box-shadow 0.2s ease;
}
.img-preview:hover {
  transform: scale(1.03);
  box-shadow: 0 3px 10px rgba(40, 167, 69, 0.2);
}

/* responsif mobile */
@media (max-width: 576px) {
  .upload-item {
    flex-direction: column;
    align-items: flex-start;
    gap: 10px;
  }
  .btn-group {
    width: 100%;
    justify-content: flex-start;
  }
  .upload-btn {
    width: 40px;
    height: 40px;
  }
}
</style>
