<div class="card shadow mb-4">
  <div class="card-header py-3 d-flex flex-wrap justify-content-between align-items-center">
    <h6 class="m-0 font-weight-bold text-success mb-2 mb-md-0">
      Detail Form Gesek – <?= strtoupper($form['no_pol'] ?? '-'); ?>
    </h6>

    <div class="d-flex flex-wrap gap-2">
      <a href="<?= base_url('form'); ?>" class="btn btn-secondary btn-sm mb-1">
        <i class="fas fa-arrow-left"></i> Kembali
      </a>
      <a href="<?= base_url('form/print/'.$form['id']); ?>" target="_blank" class="btn btn-success btn-sm mb-1">
        <i class="fas fa-download"></i> Download
      </a>
    </div>
  </div>

  <div class="card-body">
    <div class="row">
      <!-- === Data Kendaraan & Teknis === -->
      <div class="col-md-6 mb-4">
        <h6 class="text-primary font-weight-bold">Data Kendaraan</h6>
        <table class="table table-sm table-borderless text-gray-800">
          <tr><th width="160">Nomor Polisi</th><td><?= strtoupper($form['no_pol'] ?? '-'); ?></td></tr>
          <tr><th>Tipe Kendaraan</th><td><?= strtoupper($form['tipe_kendaraan'] ?? '-'); ?></td></tr>
          <tr><th>Nama Pemilik</th><td><?= strtoupper($form['nama_pemilik'] ?? '-'); ?></td></tr>
          <tr><th>Pool</th><td><?= strtoupper($form['pool'] ?? '-'); ?></td></tr>
        </table>

        <h6 class="text-primary font-weight-bold mt-3">Data Tanggal</h6>
        <table class="table table-sm table-borderless text-gray-800">
          <tr>
            <th width="160">Tanggal In Pool</th>
            <td><?= !empty($form['tgl_inpool']) ? date('d M Y', strtotime($form['tgl_inpool'])) : '-'; ?></td>
          </tr>
          <tr>
            <th>Tanggal Gesek</th>
            <td><?= !empty($form['tgl_gesek']) ? date('d M Y', strtotime($form['tgl_gesek'])) : '-'; ?></td>
          </tr>
        </table>

        <h6 class="text-primary font-weight-bold mt-3">Data Teknis</h6>
        <table class="table table-sm table-borderless text-gray-800">
          <tr><th width="160">Nomor Rangka (NOKA)</th><td><?= strtoupper($form['noka'] ?? '-'); ?></td></tr>
          <tr><th>Nomor Mesin (NOSIN)</th><td><?= strtoupper($form['nosin'] ?? '-'); ?></td></tr>
        </table>
      </div>

      <!-- === Keterangan & Petugas === -->
      <div class="col-md-6 mb-4">
        <h6 class="text-primary font-weight-bold">Keterangan</h6>
        <table class="table table-sm table-borderless text-gray-800">
          <tr>
            <th width="160">Keterangan Check</th>
            <td><?= !empty($form['keterangan_check']) ? nl2br($form['keterangan_check']) : '-'; ?></td>
          </tr>
          <tr>
            <th>Keterangan Lain</th>
            <td><?= !empty($form['keterangan']) ? nl2br($form['keterangan']) : '-'; ?></td>
          </tr>
        </table>

        <h6 class="text-primary font-weight-bold mt-3">Data Petugas</h6>
        <table class="table table-sm table-borderless text-gray-800">
          <tr><th width="160">Nama Petugas</th><td><?= strtoupper($form['petugas'] ?? '-'); ?></td></tr>
          <tr><th>Tanggal Input</th><td><?= !empty($form['created_at']) ? date('d M Y H:i', strtotime($form['created_at'])) : '-'; ?></td></tr>
        </table>
      </div>
    </div>

    <hr>

    <!-- === Foto Kendaraan === -->
    <h6 class="text-primary font-weight-bold mb-3">Foto Kendaraan</h6>
    <div class="row">
      <?php 
      $fotos = [
        'foto_noka_nosin' => 'Foto NOKA NOSIN',
        'foto_noka'  => 'Foto Nomor Rangka',
        'foto_nosin' => 'Foto Nomor Mesin'
      ];
      foreach ($fotos as $key => $label): ?>
        <div class="col-12 col-md-4 mb-3">
          <div class="card h-100 border shadow-sm">
            <div class="card-header bg-success text-white p-2 text-center">
              <?= $label; ?>
            </div>
            <div class="card-body p-2 d-flex align-items-center justify-content-center bg-light">
              <?php if (!empty($form[$key])): ?>
                <img src="<?= base_url('assets/uploads/'.$form[$key]); ?>"
                     alt="<?= $label; ?>"
                     class="img-fluid rounded foto-detail shadow-sm">
              <?php else: ?>
                <span class="text-muted small">Tidak ada foto</span>
              <?php endif; ?>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>

<!-- =====================
     🎨 STYLING
===================== -->
<style>
.table th {
  color: #495057;
  font-weight: 600;
  vertical-align: top;
}
.table td {
  color: #212529;
  word-wrap: break-word;
}

.foto-detail {
  max-height: 220px;
  object-fit: contain;
  border-radius: 10px;
  border: 2px solid #e9ecef;
  background: #fff;
  transition: transform 0.25s ease, box-shadow 0.25s ease;
}
.foto-detail:hover {
  transform: scale(1.05);
  box-shadow: 0 4px 12px rgba(40,167,69,0.25);
}

.card-header.bg-success {
  font-weight: 600;
  font-size: 0.9rem;
}

@media (max-width: 767px) {
  .card-header h6 { font-size: 0.95rem; }
  .foto-detail { max-height: 180px; }
}
</style>
