// application/libraries/Pdf_maker.php
<?php defined('BASEPATH') OR exit('No direct script access allowed');
use Dompdf\Dompdf; use Dompdf\Options;

class Pdf_maker {
    protected $dompdf;
    public function __construct() {
        $opt = new Options();
        $opt->set('isRemoteEnabled', true);
        $opt->set('isHtml5ParserEnabled', true);
        $this->dompdf = new Dompdf($opt);
    }
    public function save_html_to_pdf(string $html, string $path, string $paper='A4', string $orient='portrait'): string {
        $this->dompdf->setPaper($paper, $orient);
        $this->dompdf->loadHtml($html, 'UTF-8');
        $this->dompdf->render();
        $out = $this->dompdf->output();
        @mkdir(dirname($path), 0755, true);
        file_put_contents($path, $out);
        return $path;
    }
    public function render_to_string(string $html, string $paper='A4', string $orient='portrait'): string {
        $this->dompdf->setPaper($paper, $orient);
        $this->dompdf->loadHtml($html, 'UTF-8');
        $this->dompdf->render();
        return $this->dompdf->output();
    }
}
