<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Biaya_model extends CI_Model {

    private $table = 'Biaya';

    public function get_all() {
        return $this->db->order_by('Tahun', 'DESC')->get($this->table)->result();
    }

    public function get_by_jenis($jenis) {
        return $this->db->where('Jenis', $jenis)
                        ->order_by('Tahun', 'DESC')
                        ->get($this->table)->result();
    }

    public function get_current($jenis, $negara = null, $perusahaan = null, $tahun = null) {
        $this->db->where('Jenis', $jenis);
        if ($negara) $this->db->where('Negara', $negara);
        if ($perusahaan) $this->db->where('Perusahaan', $perusahaan);
        if ($tahun) $this->db->where('Tahun', $tahun);
        else $this->db->where('Tahun', date('Y'));
        return $this->db->get($this->table)->row();
    }

    public function insert($data) {
        $data['CreatedAt'] = date('Y-m-d H:i:s');
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }

    public function update($id, $data) {
        $data['UpdatedAt'] = date('Y-m-d H:i:s');
        return $this->db->where('BiayaID', $id)->update($this->table, $data);
    }

    public function delete($id) {
        return $this->db->delete($this->table, ['BiayaID' => $id]);
    }
}
