<?php $this->load->view('templates/auth_header'); ?>

<div class="container">

  <div class="row justify-content-center">
    <div class="col-lg-5">

      <div class="card o-hidden border-0 shadow-lg my-5">
        <div class="card-body p-5">

          <!-- Logo -->
          <div class="text-center mb-4">
            <img src="<?= base_url('assets/sb-admin2/img/hsilogo.png'); ?>" alt="HSI Logo" style="width:120px;">
          </div>

          <!-- Judul -->
          <h3 class="text-center mb-2">Login Siswa</h3>
          <p class="font-weight-light text-center mb-4" style="font-size:0.9rem;">
            Gunakan <strong>email</strong> atau <strong>no HP</strong> yang terdaftar, baik dari
            pendaftaran <b>HSI</b> maupun <b>RAFTEL</b>.
          </p>

          <!-- Flash Messages -->
          <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
              <?= $this->session->flashdata('error'); ?>
            </div>
          <?php endif; ?>

          <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
              <?= $this->session->flashdata('success'); ?>
            </div>
          <?php endif; ?>

          <!-- Form -->
          <form method="post" action="<?= base_url('login_siswa'); ?>">

            <div class="form-group">
              <input
                type="text"
                name="identity"
                class="form-control form-control-lg"
                placeholder="Email atau No HP"
                value="<?= isset($remember_identity) ? $remember_identity : set_value('identity'); ?>"
                required
                autofocus>
            </div>

            <div class="form-group">
              <input
                type="password"
                name="password"
                class="form-control form-control-lg"
                placeholder="Password"
                required>
            </div>

            <div class="form-check mb-3">
              <input
                type="checkbox"
                class="form-check-input"
                id="remember"
                name="remember"
                <?= !empty($remember_identity) ? 'checked' : ''; ?>>
              <label class="form-check-label" for="remember">Ingat saya</label>
            </div>

            <button type="submit" class="btn btn-block btn-primary btn-lg">
              Login
            </button>

            <div class="text-center mt-4 font-weight-light" style="font-size:0.9rem;">
              Belum punya akun?
              <br>
             <a href="<?= base_url('auth/register_hsi'); ?>">Registrasi HSI</a> |
              <a href="<?= base_url('auth/register_raftel'); ?>">Registrasi RAFTEL</a>
              <hr>
              <a href="<?= base_url('login_admin'); ?>">Login Admin</a> |
              <a href="<?= base_url('forgot_password'); ?>" class="text-danger">Lupa password?</a>
            </div>

          </form>

        </div>
      </div>

    </div>
  </div>

</div>

<?php $this->load->view('templates/auth_footer'); ?>
