<?php $this->load->view('templates/auth_header'); ?>

<div class="container">
  <div class="card o-hidden border-0 shadow-lg my-5">
    <div class="card-body p-5">

      <!-- Logo & Judul -->
      <div class="text-center mb-4">
        <img src="<?= base_url('assets/sb-admin2/img/hsilogo.png'); ?>" alt="HSI Logo" style="width:120px;">
        <h1 class="h4 text-gray-900 mt-3">Registrasi Siswa</h1>
      </div>

      <!-- Flash Messages -->
      <?php if ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
      <?php endif; ?>
      <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
      <?php endif; ?>

      <!-- Form -->
      <form class="user" method="post" action="<?= base_url('register'); ?>" enctype="multipart/form-data">

        <!-- Data Akun -->
        <h5 class="text-primary mb-3">Data Akun</h5>
        <div class="form-group row">
          <div class="col-md-6 mb-3">
            <input type="email" name="email" class="form-control form-control-user" 
                   placeholder="Email" value="<?= set_value('email'); ?>" required>
            <?= form_error('email', '<small class="text-danger">', '</small>'); ?>
          </div>
          <div class="col-md-6">
            <input type="text" name="phone" class="form-control form-control-user" 
                   placeholder="No HP" value="<?= set_value('phone'); ?>" required>
            <?= form_error('phone', '<small class="text-danger">', '</small>'); ?>
          </div>
        </div>
        <div class="form-group">
          <input type="password" name="password" class="form-control form-control-user" 
                 placeholder="Password Minimal 6 karakter" required>
          <?= form_error('password', '<small class="text-danger">', '</small>'); ?>
        </div>

        <!-- Data Identitas -->
        <h5 class="text-primary mt-4 mb-3">Data Identitas</h5>
        <div class="form-group">
          <input type="text" name="nama_lengkap" class="form-control form-control-user" 
                 placeholder="Nama Lengkap" value="<?= set_value('nama_lengkap'); ?>" required>
          <?= form_error('nama_lengkap', '<small class="text-danger">', '</small>'); ?>
        </div>

        <!-- Tanggal Lahir -->
        <div class="form-group">
          <label>Tanggal Lahir</label>
          <input type="date" name="tanggal_lahir" class="form-control" required>
        </div>

        <!-- Usia -->
        <div class="form-group">
          <label>Usia</label>
          <div class="input-group">
            <input type="number" name="usia" class="form-control" placeholder="15 - 35" 
                   min="15" max="35" value="<?= set_value('usia'); ?>" required>
            <div class="input-group-append"><span class="input-group-text">tahun</span></div>
          </div>
        </div>

        <!-- Tinggi & Berat Badan -->
        <div class="form-row">
          <div class="form-group col-md-6">
            <label>Tinggi Badan</label>
            <div class="input-group">
              <input type="number" name="tinggi_badan" class="form-control" placeholder="140 - 220" 
                     min="140" max="220" value="<?= set_value('tinggi_badan'); ?>" required>
              <div class="input-group-append"><span class="input-group-text">cm</span></div>
            </div>
          </div>
          <div class="form-group col-md-6">
            <label>Berat Badan</label>
            <div class="input-group">
              <input type="number" name="berat_badan" class="form-control" placeholder="40 - 120" 
                     min="40" max="120" value="<?= set_value('berat_badan'); ?>" required>
              <div class="input-group-append"><span class="input-group-text">kg</span></div>
            </div>
          </div>
        </div>

        <!-- Jenis Kelamin -->
        <div class="form-group">
          <label class="d-block">Jenis Kelamin</label>
          <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="jenis_kelamin" value="Pria" <?= set_radio('jenis_kelamin','Pria'); ?> required>
            <label class="form-check-label">Pria</label>
          </div>
          <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="jenis_kelamin" value="Perempuan" <?= set_radio('jenis_kelamin','Perempuan'); ?> required>
            <label class="form-check-label">Perempuan</label>
          </div>
        </div>

        <div class="form-group">
          <input type="text" name="domisili" class="form-control form-control-user" 
                 placeholder="Domisili" value="<?= set_value('domisili'); ?>" required>
        </div>

        <!-- Pendidikan -->
        <div class="form-group">
          <select name="pendidikan" class="form-control" required>
            <option value="">-- Pendidikan Terakhir --</option>
            <option value="SMA" <?= set_select('pendidikan','SMA'); ?>>SMA</option>
            <option value="SMK" <?= set_select('pendidikan','SMK'); ?>>SMK</option>
            <option value="MA" <?= set_select('pendidikan','MA'); ?>>MA</option>
            <option value="D3" <?= set_select('pendidikan','D3'); ?>>D3</option>
            <option value="S1" <?= set_select('pendidikan','S1'); ?>>S1</option>
            <option value="S2" <?= set_select('pendidikan','S2'); ?>>S2</option>
            <option value="S3" <?= set_select('pendidikan','S3'); ?>>S3</option>
          </select>
        </div>

        <div class="form-group">
          <input type="text" name="nama_sekolah" class="form-control form-control-user" 
                 placeholder="Nama Sekolah Terakhir" value="<?= set_value('nama_sekolah'); ?>" required>
        </div>
        <div class="form-group">
          <input type="text" name="jurusan" class="form-control form-control-user" 
                 placeholder="Jurusan" value="<?= set_value('jurusan'); ?>" required>
        </div>


        <!-- Lainnya -->
        <div class="form-group">
          <select name="tato" class="form-control" required>
            <option value="">-- Memiliki Tato --</option>
            <option value="ADA">ADA</option>
            <option value="TIDAK ADA">TIDAK ADA</option>
            <option value="SUDAH DIHAPUS">SUDAH DIHAPUS</option>
          </select>
        </div>

        <div class="form-group">
          <select name="penglihatan" class="form-control" required>
            <option value="">-- Kondisi Penglihatan --</option>
            <option value="NORMAL">NORMAL</option>
            <option value="RABUN JAUH">RABUN JAUH</option>
            <option value="RABUN DEKAT">RABUN DEKAT</option>
            <option value="SILINDER">SILINDER</option>
            <option value="BUTA WARNA">BUTA WARNA</option>
          </select>
        </div>

        <div class="form-group">
          <select name="info_pendaftaran" class="form-control" required>
            <option value="">-- Info Pendaftaran Dari --</option>
            <option value="INSTAGRAM">INSTAGRAM</option>
            <option value="TIKTOK">TIKTOK</option>
            <option value="FACEBOOK">FACEBOOK</option>
            <option value="TEMAN">TEMAN</option>
            <option value="SAUDARA">SAUDARA</option>
          </select>
        </div>

        <div class="form-group">
          <input type="text" name="rekomendasi_lpk" class="form-control form-control-user" 
                 placeholder="Rekomendasi LPK" value="<?= set_value('rekomendasi_lpk'); ?>">
        </div>

        <!-- Pilih LPK -->
<div class="form-group">
  <label for="lpk_id">Pilih LPK</label>
  <select name="lpk_id" id="lpk_id" class="form-control" required>
    <option value="">-- Pilih LPK --</option>
    <?php foreach ($lpk_list as $lpk): ?>
      <option value="<?= $lpk->LPKID; ?>"><?= $lpk->NamaLPK; ?></option>
    <?php endforeach; ?>
    <option value="new">+ Tambah LPK Baru</option>
  </select>
</div>

<!-- Form Tambah LPK Baru -->
<div id="new-lpk-form" style="display:none;">
  <div class="form-group">
    <input type="text" id="new_lpk_name" class="form-control" placeholder="Nama LPK (wajib)">
  </div>
  <div class="form-group">
    <input type="text" id="new_lpk_alamat" class="form-control" placeholder="Alamat LPK (opsional)">
  </div>
  <div class="form-group">
    <input type="text" id="new_lpk_kontak" class="form-control" placeholder="Kontak LPK (opsional)">
  </div>
  <button type="button" id="save-lpk" class="btn btn-sm btn-primary">Save</button>
  <button type="button" id="cancel-lpk" class="btn btn-sm btn-secondary">Cancel</button>
</div>


        <!-- Upload Dokumen -->
        <h5 class="text-primary mt-4 mb-3">Upload Dokumen</h5>
        <div class="form-group"><label>Pas Foto (wajib)</label><input type="file" name="pas_foto" class="form-control" required></div>
        <div class="form-group"><label>KTP (wajib)</label><input type="file" name="ktp" class="form-control" required></div>
        <div class="form-group"><label>KK (wajib)</label><input type="file" name="kk" class="form-control" required></div>
        <div class="form-group"><label>Akta Kelahiran (wajib)</label><input type="file" name="akta" class="form-control" required></div>
        <div class="form-group"><label>Paspor (opsional)</label><input type="file" name="pasport" class="form-control"></div>
        <div class="form-group"><label>Ijazah (opsional)</label><input type="file" name="ijazah" class="form-control"></div>

        <!-- Submit -->
        <button type="submit" class="btn btn-success btn-user btn-block">Daftar</button>
      </form>

      <hr>
      <div class="text-center">
        Sudah punya akun? <a href="<?= base_url('login_siswa'); ?>" class="text-primary">Login</a>
      </div>

    </div>
  </div>
</div>


<?php $this->load->view('templates/auth_footer'); ?>
