<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container-fluid">
  <h1 class="h3 mb-4 text-gray-800"><?= html_escape($title ?? 'Kelola Siswa') ?></h1>

  <!-- Form Pencarian -->
  <form method="get" action="<?= base_url('siswa') ?>" class="form-inline mb-3">
    <input type="text" name="keyword" class="form-control mr-2"
           placeholder="Cari siswa (ID / Nama / Email / No HP)"
           value="<?= html_escape($keyword ?? '') ?>">
    <button type="submit" class="btn btn-primary mr-2">Cari</button>
    <a href="<?= base_url('siswa') ?>" class="btn btn-secondary">Reset</a>
  </form>

  <?php if($this->session->flashdata('success')): ?>
    <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
  <?php endif; ?>
  <?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
  <?php endif; ?>

  <div class="card shadow mb-4">
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered table-hover mb-0">
          <thead class="thead-light">
            <tr>
              <th style="width:140px">SiswaID</th>
              <th>Nama Lengkap</th>
              <th>Email</th>
              <th>No HP</th>
              <th style="width:120px">Status</th>
              <th style="width:220px">Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($siswa)): ?>
              <?php foreach($siswa as $row): ?>
                <?php
                  $sid   = $row->SiswaID ?? '';
                  $uid   = (int)($row->UserID ?? 0);
                  $nama  = $row->NamaLengkap ?? '';
                  $email = $row->Email ?? '';
                  $hp    = $row->Phone ?? '';
                  $stat  = $row->NamaStatus ?? 'Belum ditentukan';

                  // badge map
                  $badgeClass = 'badge-secondary';
                  $sLow = strtolower(trim($stat));
                  if ($sLow === 'aktif')   $badgeClass = 'badge-success';
                  elseif ($sLow === 'ditolak' || $sLow === 'rejected') $badgeClass = 'badge-danger';
                  elseif ($sLow === 'calon') $badgeClass = 'badge-secondary';
                ?>
                <tr>
                  <td><?= $sid ? html_escape($sid) : '<span class="text-muted">— calon —</span>' ?></td>
                  <td><?= html_escape($nama) ?></td>
                  <td><?= html_escape($email) ?></td>
                  <td><?= html_escape($hp) ?></td>
                  <td><span class="badge <?= $badgeClass ?>"><?= html_escape($stat) ?></span></td>
                  <td>
  <?php
    $sid   = $row->SiswaID ?? '';
    $stat  = trim(strtolower($row->NamaStatus ?? ''));
    $isAktif   = ($stat === 'aktif');
    $isDitolak = ($stat === 'ditolak' || $stat === 'rejected');

    // URL aksi
    $detailUrl = base_url('siswa/detail/'.rawurlencode($sid));
    $editUrl   = base_url('siswa/ubahstatus/'.rawurlencode($sid));
    $hapusUrl  = base_url('siswa/hapus/'.rawurlencode($sid));

    // Konfirmasi hapus: beda pesan untuk ditolak vs lainnya (arsip)
    $confirmMsg = $isDitolak
      ? 'Hapus permanen siswa ini? Semua data terkait akan dihapus.'
      : 'Arsipkan siswa ini? Data tidak akan dihapus permanen dan bisa dipulihkan.';

    // Tampilan tombol hapus: merah solid untuk permanen, outline untuk arsip
    $hapusBtnClass = $isDitolak ? 'btn btn-sm btn-danger' : 'btn btn-sm btn-outline-danger';
  ?>

  <?php if ($sid): ?>
    <a href="<?= $detailUrl ?>" class="btn btn-sm btn-info">Detail</a>

    <?php if ($isAktif): ?>
      <a href="<?= $editUrl ?>" class="btn btn-sm btn-warning">Ubah Status</a>
    <?php else: ?>
      <button class="btn btn-sm btn-warning" disabled title="Hanya bisa diubah bila status Aktif">Ubah Status</button>
    <?php endif; ?>

    <a href="<?= $hapusUrl ?>"
       class="<?= $hapusBtnClass ?>"
       onclick="return confirm('<?= $confirmMsg ?>');">
      Hapus
    </a>
  <?php else: ?>
    <!-- Calon (belum punya SiswaID) -->
    <button class="btn btn-sm btn-info" disabled>Detail</button>
    <button class="btn btn-sm btn-warning" disabled>Ubah Status</button>
    <button class="btn btn-sm btn-outline-danger" disabled>Hapus</button>
  <?php endif; ?>
</td>

                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr>
                <td colspan="6" class="text-center text-muted">Tidak ada data.</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?php $this->load->view('templates/footer'); ?>
