<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container-fluid">
  <h1 class="h3 mb-4 text-gray-800"><?= $title ?></h1>

  <div class="row">
    <!-- Kolom Detail -->
    <div class="col-md-8">
      <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h6 class="m-0 font-weight-bold text-primary">Detail Siswa</h6>
          <?php if ($siswa->NamaStatus == 'Calon'): ?>
            <span class="badge badge-secondary p-2" style="font-size: 1rem;"><?= $siswa->NamaStatus ?></span>
          <?php elseif ($siswa->NamaStatus == 'Aktif'): ?>
            <span class="badge badge-success p-2" style="font-size: 1rem;"><?= $siswa->NamaStatus ?></span>
          <?php elseif ($siswa->NamaStatus == 'Ditolak'): ?>
            <span class="badge badge-danger p-2" style="font-size: 1rem;"><?= $siswa->NamaStatus ?></span>
          <?php else: ?>
            <span class="badge badge-warning p-2" style="font-size: 1rem;">Belum ditentukan</span>
          <?php endif; ?>
        </div>
        <div class="card-body">
          <table class="table table-borderless">
            <tr><th>ID</th><td><?= $siswa->SiswaID ?></td></tr>
            <tr><th>Nama Lengkap</th><td><?= $siswa->NamaLengkap ?></td></tr>
            <tr><th>Email</th><td><?= $siswa->Email ?></td></tr>
            <tr><th>No HP</th><td><?= $siswa->Phone ?></td></tr>
            <tr><th>Tanggal Lahir</th><td><?= $siswa->TanggalLahir ?></td></tr>
            <tr><th>Usia</th><td><?= $siswa->Usia ?></td></tr>
            <tr><th>Tinggi Badan</th><td><?= $siswa->TinggiBadan ?> cm</td></tr>
            <tr><th>Berat Badan</th><td><?= $siswa->BeratBadan ?> kg</td></tr>
            <tr><th>Jenis Kelamin</th><td><?= $siswa->JenisKelamin ?></td></tr>
            <tr><th>Domisili</th><td><?= $siswa->Domisili ?></td></tr>
            <tr><th>Pendidikan</th><td><?= $siswa->Pendidikan ?></td></tr>
            <tr><th>Nama Sekolah</th><td><?= $siswa->NamaSekolah ?></td></tr>
            <tr><th>Jurusan</th><td><?= $siswa->Jurusan ?></td></tr>
            <tr><th>Tato</th><td><?= $siswa->Tato ?></td></tr>
            <tr><th>Penglihatan</th><td><?= $siswa->Penglihatan ?></td></tr>
            <tr><th>Info Pendaftaran</th><td><?= $siswa->InfoPendaftaran ?></td></tr>
            <tr><th>Rekomendasi LPK</th><td><?= $siswa->RekomendasiLPK ?></td></tr>
          </table>
        </div>
      </div>
    </div>

    <!-- Kolom Foto -->
    <div class="col-md-4">
      <div class="card shadow mb-4">
        <div class="card-header">
          <h6 class="m-0 font-weight-bold text-primary">Foto Siswa</h6>
        </div>
        <div class="card-body text-center">
          <?php 
            $foto = null;
            if (!empty($dokumen)) {
              foreach ($dokumen as $d) {
                if ($d->JenisDokumen == 'pas_foto') {
                  $foto = $d->FilePath;
                }
              }
            }
          ?>
          <?php if($foto): ?>
            <img src="<?= base_url('uploads/siswa/'.$siswa->SiswaID.'/'.$foto) ?>" 
                 alt="Foto Siswa" class="img-fluid rounded mb-2" style="max-height:300px;">
          <?php else: ?>
            <img src="<?= base_url('assets/img/default-user.png') ?>" 
                 alt="Default Foto" class="img-fluid rounded mb-2" style="max-height:300px;">
            <p class="text-muted">Belum ada foto</p>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>

  <!-- Dokumen -->
  <div class="card shadow mb-4">
    <div class="card-header py-3">
      <h6 class="m-0 font-weight-bold text-primary">Dokumen Siswa</h6>
    </div>
    <div class="card-body">
      <table class="table table-bordered">
        <thead>
          <tr><th>Jenis Dokumen</th><th>File</th></tr>
        </thead>
        <tbody>
          <?php 
            $jenis = ['pas_foto'=>'Pas Foto','ktp'=>'KTP','kk'=>'Kartu Keluarga','akta'=>'Akta','pasport'=>'Paspor','ijazah'=>'Ijazah'];
            foreach ($jenis as $key=>$label): 
              $file = null;
              if (!empty($dokumen)) {
                foreach ($dokumen as $d) {
                  if ($d->JenisDokumen == $key) {
                    $file = $d->FilePath;
                  }
                }
              }
          ?>
          <tr>
            <td><?= $label ?></td>
            <td>
              <?php if($file): ?>
                <a href="<?= base_url('uploads/siswa/'.$siswa->SiswaID.'/'.$file) ?>" 
                   target="_blank" class="btn btn-sm btn-info">Lihat</a>
              <?php else: ?>
                <span class="text-muted">Belum diupload</span>
              <?php endif; ?>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

</div>

<?php $this->load->view('templates/footer'); ?>
