<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container-fluid">
  <h1 class="h3 mb-4 text-gray-800"><?= html_escape($title ?? 'Siswa Ditolak') ?></h1>

  <?php if ($this->session->flashdata('success')): ?>
    <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
  <?php endif; ?>
  <?php if ($this->session->flashdata('error')): ?>
    <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
  <?php endif; ?>

  <div class="card shadow mb-4">
    <div class="card-body">
      <?php if (empty($siswa)): ?>
        <div class="text-center text-muted py-4">Tidak ada data siswa ditolak.</div>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table table-bordered table-striped mb-0">
            <thead class="thead-light">
              <tr>
                <th style="width:140px;">SiswaID</th>
                <th>Nama Lengkap</th>
                <th>Email</th>
                <th>Phone</th>
                <th>LPK</th>
                <th style="width:170px;">Tanggal Daftar</th>
                <th style="width:260px;">Aksi</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($siswa as $row): ?>
                <?php
                  $sid   = $row->SiswaID   ?? '';
                  $uid   = (int)($row->UserID ?? 0);
                  $nama  = $row->NamaLengkap ?? '-';
                  $email = $row->Email ?? '-';
                  $hp    = $row->Phone ?? '-';
                  $lpk   = $row->NamaLPK ?? '-';
                  $ctAt  = $row->CreatedAt ?? '';
                  $ctFmt = $ctAt ? date('d M Y H:i', strtotime($ctAt)) : '-';
                ?>
                <tr>
                  <td><?= $sid ? html_escape($sid) : '<span class="text-muted">—</span>' ?></td>
                  <td><?= html_escape($nama) ?></td>
                  <td><?= html_escape($email) ?></td>
                  <td><?= html_escape($hp) ?></td>
                  <td><?= html_escape($lpk) ?></td>
                  <td><?= html_escape($ctFmt) ?></td>
                  <td>
                    <?php if ($sid): ?>
                      <a href="<?= base_url('dashboard/kembalikan_siswa/'.rawurlencode($sid)); ?>"
                         class="btn btn-sm btn-warning"
                         onclick="return confirm('Kembalikan siswa ini ke status sebelumnya dan tampilkan kembali di Kelola Siswa?');">
                        Kembalikan
                      </a>
                    <?php else: ?>
                      <button class="btn btn-sm btn-warning" disabled title="SiswaID tidak tersedia">Kembalikan</button>
                    <?php endif; ?>

                    <?php if ($uid > 0): ?>
                      <a href="<?= base_url('dashboard/hapus_permanen_user/'.$uid); ?>"
                         class="btn btn-sm btn-danger"
                         onclick="return confirm('Hapus permanen SEMUA data milik user ini (termasuk akun Users, pembayaran, dokumen)? Tindakan tidak bisa dibatalkan.');">
                        Hapus Permanen
                      </a>
                    <?php else: ?>
                      <button class="btn btn-sm btn-danger" disabled title="UserID tidak tersedia">Hapus Permanen</button>
                    <?php endif; ?>

                    <!-- (Opsional) Detail cepat -->
                    <?php if ($sid): ?>
                      <a href="<?= base_url('siswa/detail/'.rawurlencode($sid)); ?>"
                         class="btn btn-sm btn-info">
                        Detail
                      </a>
                    <?php endif; ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>

<?php $this->load->view('templates/footer'); ?>
