
<div class="container-fluid">

  <div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800"><?= html_escape($title ?? 'Laporan Keuangan'); ?></h1>
    <div>
      <a href="<?= base_url('laporan-keuangan/pdf?' . http_build_query($filters)); ?>" 
   class="btn btn-sm btn-danger">
  <i class="fas fa-file-pdf fa-sm"></i> Export PDF
</a>
      <a href="<?= base_url('laporan-keuangan/excel?' . http_build_query($filters)); ?>" 
   class="btn btn-sm btn-success">
  <i class="fas fa-file-excel fa-sm"></i> Export Excel
</a>
    </div>
  </div>

  <!-- Filter -->
  <div class="card mb-4 shadow">
    <div class="card-header py-3">
      <h6 class="m-0 font-weight-bold text-primary">Filter Laporan</h6>
    </div>
    <div class="card-body">
      <form class="row g-3" method="get" action="<?= base_url('laporan_keuangan'); ?>">
        <div class="col-md-3">
          <label for="date_from" class="form-label">Dari Tanggal</label>
          <input type="date" name="date_from" id="date_from" class="form-control"
                 value="<?= html_escape($filters['date_from']); ?>">
        </div>
        <div class="col-md-3">
          <label for="date_to" class="form-label">Sampai Tanggal</label>
          <input type="date" name="date_to" id="date_to" class="form-control"
                 value="<?= html_escape($filters['date_to']); ?>">
        </div>
        <div class="col-md-3">
          <label for="status" class="form-label">Status</label>
          <select name="status" id="status" class="form-control">
            <option value="all" <?= $filters['status'] == 'all' ? 'selected' : ''; ?>>Semua</option>
            <option value="lunas" <?= $filters['status'] == 'lunas' ? 'selected' : ''; ?>>Lunas</option>
            <option value="belum_lunas" <?= $filters['status'] == 'belum_lunas' ? 'selected' : ''; ?>>Belum Lunas</option>
          </select>
        </div>
        <div class="col-md-3">
          <label for="metode" class="form-label">Metode</label>
          <select name="metode" id="metode" class="form-control">
            <option value="all" <?= $filters['metode'] == 'all' ? 'selected' : ''; ?>>Semua</option>
            <option value="cash" <?= $filters['metode'] == 'cash' ? 'selected' : ''; ?>>Cash</option>
            <option value="transfer" <?= $filters['metode'] == 'transfer' ? 'selected' : ''; ?>>Transfer</option>
            <!-- Tambah opsi lain kalau ada -->
          </select>
        </div>

        <div class="col-12 mt-3">
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-search"></i> Tampilkan
          </button>
          <a href="<?= base_url('laporan_keuangan'); ?>" class="btn btn-secondary">
            Reset
          </a>
        </div>
      </form>
    </div>
  </div>

  <!-- Rekap -->
  <div class="row mb-4">
    <div class="col-md-4">
      <div class="card border-left-primary shadow h-100 py-2">
        <div class="card-body">
          <div class="row no-gutters align-items-center">
            <div class="col mr-2">
              <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                Total Transaksi</div>
              <div class="h5 mb-0 font-weight-bold text-gray-800">
                <?= number_format($rekap['total_transaksi'] ?? 0, 0, ',', '.'); ?>
              </div>
            </div>
            <div class="col-auto">
              <i class="fas fa-receipt fa-2x text-gray-300"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-4">
      <div class="card border-left-success shadow h-100 py-2">
        <div class="card-body">
          <div class="row no-gutters align-items-center">
            <div class="col mr-2">
              <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                Total Pemasukan</div>
              <div class="h5 mb-0 font-weight-bold text-gray-800">
                Rp <?= number_format($rekap['total_pemasukan'] ?? 0, 0, ',', '.'); ?>
              </div>
            </div>
            <div class="col-auto">
              <i class="fas fa-money-bill-wave fa-2x text-gray-300"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>

  <!-- Tabel Detail -->
  <div class="card shadow mb-4">
    <div class="card-header py-3">
      <h6 class="m-0 font-weight-bold text-primary">Detail Transaksi</h6>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered table-sm" width="100%" cellspacing="0">
          <thead class="thead-light">
            <tr>
              <th>#</th>
              <th>Tanggal</th>
              <th>Nama Siswa</th>
              <th>Keterangan</th>
              <th>Metode</th>
              <th>Status</th>
              <th class="text-right">Jumlah (Rp)</th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($pembayaran)): ?>
              <?php 
              $no = 1; 
              $subtotal = 0;
              foreach ($pembayaran as $row): 
                  $subtotal += (float) $row['jumlah_bayar'];
              ?>
                <tr>
                  <td><?= $no++; ?></td>
                  <td><?= html_escape($row['tanggal_bayar']); ?></td>
                  <td><?= html_escape($row['nama_siswa']); ?></td>
                  <td><?= html_escape($row['keterangan']); ?></td>
                  <td><?= html_escape(ucfirst($row['metode_bayar'])); ?></td>
                  <td>
                    <span class="badge badge-<?= $row['status'] == 'lunas' ? 'success' : 'warning'; ?>">
                      <?= strtoupper($row['status']); ?>
                    </span>
                  </td>
                  <td class="text-right">
                    <?= number_format($row['jumlah_bayar'], 0, ',', '.'); ?>
                  </td>
                </tr>
              <?php endforeach; ?>
              <tr class="font-weight-bold">
                <td colspan="6" class="text-right">TOTAL</td>
                <td class="text-right">Rp <?= number_format($subtotal, 0, ',', '.'); ?></td>
              </tr>
            <?php else: ?>
              <tr>
                <td colspan="7" class="text-center text-muted">
                  Tidak ada data untuk periode & filter ini.
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

</div>