<?php
// ===== Helper kecil rupiah =====
if (!function_exists('rupiah')) {
  function rupiah($n){ return 'Rp '.number_format((float)$n,0,',','.'); }
}

/**
 * VARIABEL yang diharapkan (controller baru):
 * $no_invoice, $tanggal, $nama, $email, $phone, $siswaid, $lpk
 * $termin_ke, $item_rows, $subtotal, $ppn, $total
 * $sudah_bayar, $belum_bayar
 * $logo_left, $logo_right, $stempel_url, $ttd_url (opsional)
 *
 * Backward-compat:
 * - Jika $total kosong, dia ambil dari $subtotal atau total($item_rows).
 * - Jika $termin_ke kosong, diasumsikan 1.
 * - $belum_bayar default = $total - ($sudah_bayar ?? 0)
 */

// Hitung angka aman
$termin_ke   = isset($termin_ke) ? (int)$termin_ke : 1;
$subtotal    = isset($subtotal) ? (float)$subtotal : 0.0;
if ($subtotal <= 0 && !empty($item_rows) && is_array($item_rows)) {
  foreach ($item_rows as $it) $subtotal += (float)($it['amount'] ?? 0);
}
$total       = isset($total) && $total > 0 ? (float)$total : $subtotal;
$ppn         = isset($ppn) ? (float)$ppn : 0.0;
$sudah_bayar = isset($sudah_bayar) ? (float)$sudah_bayar : 0.0;
$belum_bayar = isset($belum_bayar) ? (float)$belum_bayar : max(0.0, $total - $sudah_bayar);

// Siapkan isi kolom "Tagihan" per-termin (hanya termin aktif yang terisi)
$tagihan1 = $termin_ke === 1 ? rupiah($total) : '';
$tagihan2 = $termin_ke === 2 ? rupiah($total) : '';
$tagihan3 = $termin_ke === 3 ? rupiah($total) : '';

// Aset visual default
if (empty($stempel_url) && function_exists('base_url')) {
  $stempel_url = base_url('assets/sb-admin2/img/stamp_HSI.png');
}
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Invoice Pelatihan</title>
<style>
  @page { size: A4; margin: 12mm 12mm 12mm 12mm; }
  body{ font-family: DejaVu Sans, Arial, Helvetica, sans-serif; font-size:12px; color:#111; }

  /* util */
  .right{ text-align:right; } .center{ text-align:center; } .bold{ font-weight:bold; }
  .tiny{ font-size:11px; line-height:1.5; }
  .box{ border:1px solid #ddd; border-radius:6px; padding:10px; }
  table{ border-collapse:collapse; width:100%; }
  th,td{ padding:8px 10px; border:1px solid #e5e5e5; vertical-align:top; }
  .no-b td, .no-b th{ border:none!important; }

  /* judul */
  .judul{ font-size:54px; font-weight:900; letter-spacing:2px; }

  /* kotak total due hitam */
  .pill{ background:#111; color:#fff; padding:9px 12px; border-radius:3px; display:inline-block; min-width:140px; text-align:center; }

  /* header tabel termin */
  .head-termin th{ background:#d9b651; color:#fff; text-transform:uppercase; }

  /* isi tabel termin */
  .isi-termin td{ background:#fcf5df; }

  /* footer total box (kanan) */
  .total-box{ background:#111; color:#fff; padding:8px 10px; border-radius:4px; display:inline-block; min-width:120px; }

  /* header kiri hitam */
  .blk-top{ background:#111; padding:12px 14px; }
  .tri-black{ width:0; height:0; border-left:180px solid #111; border-top:90px solid transparent; border-bottom:0 solid transparent; }

  /* footer strip */
  .foot-red{ height:18px; background:#e53935; }
  .foot-black{ height:12px; background:#111; width:65%; margin-left:35%; }

  /* stempel/ttd */
  .stempel{ height:90px; opacity:.9; }
  .ttd{ height:60px; }
  .badge{ display:inline-block; background:#222; color:#fff; padding:3px 8px; border-radius:12px; font-size:10px; margin-left:6px;}
</style>
</head>
<body>

<!-- ============ HEADER KOMPOSIT ============ -->
<table class="no-b" cellspacing="0" cellpadding="0" style="margin-bottom:6px;">
  <tr>
    <!-- kolom kiri: banner hitam + logo HSI -->
    <td style="width:45%; vertical-align:top; padding:0;">
      <div class="blk-top">
        <table class="no-b">
          <tr>
            <td style="width:60px;" class="no-b">
              <?php if(!empty($logo_left)): ?>
                <img src="<?= $logo_left ?>" style="height:54px;">
              <?php else: ?>
                <div style="height:54px;"></div>
              <?php endif; ?>
            </td>
            <td class="no-b" style="color:#fff; padding-left:10px;">
              <div style="color:#ffcc00; font-size:10px;">★★★</div>
              <div style="font-size:28px; font-weight:900; line-height:1;">HSI</div>
              <div style="font-size:9px;">JAPANESE LANGUAGE TRAINING CENTER</div>
            </td>
          </tr>
        </table>
      </div>
      <div class="tri-black"></div>
    </td>

    <!-- kolom tengah: judul besar -->
    <td style="width:25%; text-align:center; vertical-align:middle;">
      <div class="judul">INVOICE</div>
      <div class="tiny" style="margin-top:6px;">Termin <span class="badge">#<?= (int)$termin_ke ?></span></div>
    </td>

    <!-- kolom kanan: logo LPK -->
    <td style="width:30%; text-align:right; vertical-align:top;">
      <?php if(!empty($logo_right)): ?>
        <img src="<?= $logo_right ?>" style="height:70px;">
      <?php endif; ?>
    </td>
  </tr>
</table>

<!-- ============ BLOK INFO ATAS ============ -->
<table class="no-b" cellspacing="0" cellpadding="0">
  <tr>
    <td style="width:48%; padding-right:12px; vertical-align:top;">
      <div class="bold" style="margin-bottom:6px;">INVOICE TO :</div>
      <div class="box">
        <div class="bold" style="font-size:13px;"><?= html_escape($nama ?? '-') ?></div>
        <div style="height:10px;"></div>
        <?php if(!empty($email)): ?><div class="tiny"><?= html_escape($email) ?></div><?php endif; ?>
        <?php if(!empty($phone)): ?><div class="tiny"><?= html_escape($phone) ?></div><?php endif; ?>
        <?php if(!empty($siswaid)): ?><div class="tiny">SiswaID: <?= html_escape($siswaid) ?></div><?php endif; ?>
        <?php if(!empty($lpk)): ?><div class="tiny">LPK: <?= html_escape($lpk) ?></div><?php endif; ?>
        <!-- garis kecil tempat tanda tangan penerima -->
        <div style="margin-top:16px; width:60px; border-bottom:2px solid #111;"></div>
      </div>
    </td>
    <td style="width:22%; padding-right:12px; vertical-align:top;">
      <div class="tiny">
        <div><span class="bold">Invoice No :</span> <?= html_escape($no_invoice ?? '-') ?></div>
        <div style="height:4px;"></div>
        <div><span class="bold">Date :</span> Cikarang, <?= html_escape($tanggal ?? date('Y-m-d')) ?></div>
      </div>
    </td>
    <td style="width:30%; text-align:right; vertical-align:top;">
      <div class="bold" style="margin-bottom:6px;">TOTAL DUE :</div>
      <div class="pill"><?= rupiah($total) ?></div>
    </td>
  </tr>
</table>

<!-- ============ LPK ASAL ============ -->
<div class="bold" style="margin-top:14px; margin-bottom:6px;">LPK ASAL</div>

<!-- header tabel kuning -->
<table class="no-b" cellspacing="0" cellpadding="0" style="margin-bottom:2px;">
  <tr class="head-termin">
    <th style="width:33%;">Keterangan</th>
    <th>Waktu Pembayaran</th>
    <th style="width:25%;">Tagihan</th>
  </tr>
</table>

<!-- isi tabel krem (hanya termin aktif yang berisi nominal) -->
<table class="no-b" cellspacing="0" cellpadding="0">
  <tbody class="isi-termin">
    <tr>
      <td style="width:33%; border:1px solid #e5e5e5; padding:8px 10px;">TERMIN 1</td>
      <td style="border:1px solid #e5e5e5; padding:8px 10px;">LOLOS WAWANCARA</td>
      <td style="width:25%; border:1px solid #e5e5e5; padding:8px 10px;"><?= $tagihan1 ?></td>
    </tr>
    <tr>
      <td style="border:1px solid #e5e5e5; padding:8px 10px;">TERMIN 2</td>
      <td style="border:1px solid #e5e5e5; padding:8px 10px;">KONTRAK KERJA PERUSAHAAN</td>
      <td style="border:1px solid #e5e5e5; padding:8px 10px;"><?= $tagihan2 ?></td>
    </tr>
    <tr>
      <td style="border:1px solid #e5e5e5; padding:8px 10px;">TERMIN 3</td>
      <td style="border:1px solid #e5e5e5; padding:8px 10px;">TURUN COE</td>
      <td style="border:1px solid #e5e5e5; padding:8px 10px;"><?= $tagihan3 ?></td>
    </tr>
  </tbody>
</table>

<!-- ============ RINGKASAN PEMBAYARAN ============ -->
<table class="no-b" cellspacing="0" cellpadding="0" style="margin-top:16px;">
  <tr>
    <!-- kiri -->
    <td style="width:58%; padding-right:16px; vertical-align:top;">
      <div style="font-size:20px; margin-bottom:6px;">ありがとうございます</div>
      <div class="bold" style="margin-bottom:6px;">Payment Method</div>
      <table class="no-b tiny">
        <tr><td class="bold" style="width:95px;">Bank Name</td><td>: BNI</td></tr>
        <tr><td class="bold">Account No</td><td>: 1819294528</td></tr>
        <tr><td class="bold">Name Account</td><td>: Yayasan Hiroshi Seiya Indonesia</td></tr>
      </table>
    </td>

    <!-- kanan -->
    <td style="vertical-align:top;">
      <table class="no-b tiny" style="margin-top:4px;">
        <tr>
          <td class="bold" style="width:100px;">Sudah Bayar :</td>
          <td class="right"><?= rupiah($sudah_bayar) ?></td>
        </tr>
        <tr>
          <td class="bold">Belum Bayar :</td>
          <td class="right"><b><?= rupiah($belum_bayar) ?></b></td>
        </tr>
        <tr>
          <td class="bold" style="padding-top:10px;">Total :</td>
          <td class="right" style="padding-top:6px;"><span class="total-box"><?= rupiah($total) ?></span></td>
        </tr>
      </table>
    </td>
  </tr>
</table>

<!-- ============ TERMS & STAMPEL/TTD ============ -->
<table class="no-b" cellspacing="0" cellpadding="0" sty
