<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container mt-4">
    <h3 class="mb-4"><?= $title; ?></h3>

    <!-- Flash message -->
    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
    <?php endif; ?>
    <?php if ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
    <?php endif; ?>

    <?php if (empty($list)): ?>
        <div class="alert alert-info">Tidak ada pembayaran pending.</div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th>Nama Siswa</th>
                        <th>Jumlah Bayar</th>
                        <th>Tanggal</th>
                        <th>Metode</th>
                        <th>Bukti</th>
                        <th style="width:220px;">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($list as $r): ?>
                        <tr>
                            <!-- Nama Siswa -->
                            <td><?= $r->NamaLengkap ?? '<span class="text-muted">-</span>'; ?></td>

                            <!-- Jumlah Bayar -->
                            <td>
                                <?php if (!empty($r->JumlahBayar)): ?>
                                    Rp <?= number_format($r->JumlahBayar,0,',','.'); ?>
                                <?php else: ?>
                                    <span class="text-muted">Belum bayar</span>
                                <?php endif; ?>
                            </td>

                            <!-- Tanggal Bayar -->
                            <td>
                                <?php if (!empty($r->TanggalBayar)): ?>
                                    <?= date('d-m-Y H:i', strtotime($r->TanggalBayar)); ?>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>

                            <!-- Metode -->
                            <td><?= !empty($r->MetodeBayar) ? $r->MetodeBayar : '<span class="text-muted">-</span>'; ?></td>

                            <!-- Bukti Transfer -->
                            <td>
                                <?php if (!empty($r->BuktiTransfer)): ?>
                                    <a href="<?= base_url('uploads/bukti_transfer/'.$r->BuktiTransfer); ?>" 
                                       target="_blank" 
                                       class="btn btn-sm btn-outline-primary">
                                       Lihat
                                    </a>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>

                            <!-- Aksi -->
                            <td>
                                <?php if (!empty($r->PembayaranID)): ?>
                                    <!-- Approve -->
                                    <a href="<?= base_url('pembayaran/approve/'.$r->PembayaranID); ?>" 
                                       class="btn btn-sm btn-success mb-1"
                                       onclick="return confirm('Yakin approve pembayaran ini?')">
                                       Approve
                                    </a>

                                    <!-- Reject -->
                                    <?= form_open('pembayaran/reject/'.$r->PembayaranID, ['style'=>'display:inline-block']); ?>
                                        <input type="text" 
                                               name="alasan" 
                                               placeholder="Alasan reject" 
                                               class="form-control form-control-sm mb-1" 
                                               style="width:150px;">
                                        <button type="submit" class="btn btn-sm btn-danger">Reject</button>
                                    <?= form_close(); ?>
                                <?php else: ?>
                                    <span class="badge badge-secondary">Belum ada pembayaran</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<?php $this->load->view('templates/footer'); ?>
