<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container-fluid">
  <h1 class="h3 mb-4 text-gray-800">Pembayaran_pelatihan / Admin</h1>

  <?php if ($this->session->flashdata('success')): ?>
    <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
  <?php endif; ?>
  <?php if ($this->session->flashdata('error')): ?>
    <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
  <?php endif; ?>

  <div class="card shadow">
    <div class="card-header d-flex align-items-center justify-content-between">
      <h6 class="m-0 font-weight-bold text-primary">Admin - Pembayaran Pelatihan</h6>
      <div class="input-group input-group-sm" style="width:260px">
        <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-search"></i></span></div>
        <input id="tableFilter" type="text" class="form-control" placeholder="Cari nama / status…">
      </div>
    </div>

    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-hover mb-0" id="adminTable">
          <thead class="thead-light">
            <tr>
              <th style="min-width:240px">Nama Lengkap</th>
              <th style="min-width:160px">Status</th>
              <th class="text-right" style="min-width:130px">Total Biaya</th>
              <th class="text-right" style="min-width:130px">Total Bayar</th>
              <th class="text-right" style="min-width:130px">Sisa Tagihan</th>
              <th style="min-width:150px">Aksi</th>
            </tr>
          </thead>

          <tbody>
          <?php
            $fmt = function($n){ return 'Rp '.number_format((float)$n,0,',','.'); };

            if (!empty($siswa)):
              foreach ($siswa as $r):

                $nama        = trim($r['NamaLengkap'] ?? '-') ?: '-';
                $sid         = $r['SiswaID'] ?? '';
                $uid         = (int)($r['UserID'] ?? 0);

                // gunakan StatusText dari controller (fallback ke Status)
                $statusText  = $r['StatusText'] ?? ($r['Status'] ?? 'Calon');
                $statusLc    = strtolower($statusText);

                $totalBiaya  = (float)($r['TotalBiaya']  ?? 0);
                $totalBayar  = (float)($r['TotalBayar']  ?? 0);
                $sisa        = (float)($r['SisaTagihan'] ?? max(0, $totalBiaya - $totalBayar));

                // badge status
                if ($statusLc === 'aktif' || $statusLc === 'approved') {
                  $badge = '<span class="badge badge-success">Aktif</span>';
                } elseif (strpos($statusLc,'menunggu') !== false || $statusLc === 'pending') {
                  $badge = '<span class="badge badge-warning">Menunggu Pembayaran</span>';
                } elseif ($statusLc === 'rejected' || $statusLc === 'ditolak' || $statusLc === 'tolak') {
                  $badge = '<span class="badge badge-danger">Ditolak</span>';
                } else {
                  $badge = '<span class="badge badge-secondary">'.html_escape($statusText).'</span>';
                }

                // detail id = SiswaID (jika ada) else UserID
                $detail_id  = !empty($sid) ? $sid : $uid;
                $detail_url = site_url('pembayaran_pelatihan/detail/'.$detail_id);

                // tombol tolak: hanya enable bila masih ada kemungkinan pending
                $canReject  = (strpos($statusLc,'menunggu') !== false) || $statusLc === 'calon' || $statusLc === 'pending';
                $reject_url = $detail_url.'?open=reject#pending';
          ?>
            <tr>
              <td class="align-middle">
                <div class="font-weight-bold text-dark"><?= html_escape($nama); ?></div>
                <div class="small text-muted">
                  <?php if (!empty($sid)): ?>
                    ID: <?= html_escape($sid); ?>
                  <?php else: ?>
                    UserID: <?= (int)$uid; ?> (Calon)
                  <?php endif; ?>
                </div>
              </td>

              <td class="align-middle"><?= $badge; ?></td>

              <td class="align-middle text-right"><?= $fmt($totalBiaya); ?></td>
              <td class="align-middle text-right"><?= $fmt($totalBayar); ?></td>
              <td class="align-middle text-right <?= $sisa>0 ? 'text-danger font-weight-bold' : 'text-success'; ?>">
                <?= $fmt($sisa); ?>
              </td>

              <td class="align-middle">
                <div class="btn-group btn-group-sm" role="group">
                  <a href="<?= $detail_url; ?>" class="btn btn-info" title="Lihat detail & transaksi">
                    <i class="fas fa-info-circle mr-1"></i>Detail
                  </a>
                  <a href="<?= $reject_url; ?>"
                     class="btn btn-danger <?= $canReject ? '' : 'disabled'; ?>"
                     title="<?= $canReject ? 'Buka halaman detail & tolak pembayaran pending' : 'Tidak ada pembayaran pending'; ?>">
                    <i class="fas fa-times mr-1"></i>Tolak
                  </a>
                </div>
              </td>
            </tr>
          <?php
              endforeach;
            else:
          ?>
            <tr>
              <td colspan="6" class="text-center text-muted py-4">Belum ada data.</td>
            </tr>
          <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
// filter sederhana by text
document.getElementById('tableFilter').addEventListener('input', function(){
  const q = this.value.toLowerCase();
  document.querySelectorAll('#adminTable tbody tr').forEach(function(tr){
    const text = tr.innerText.toLowerCase();
    tr.style.display = text.indexOf(q) > -1 ? '' : 'none';
  });
});
</script>

<?php $this->load->view('templates/footer'); ?>
