<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container mt-4">
    <div class="card shadow">
        <div class="card-header bg-info text-white">
            <h4 class="mb-0"><?= $title; ?></h4>
        </div>
        <div class="card-body">
            <!-- Biodata Siswa -->
            <div class="mb-4">
                <h5 class="font-weight-bold">Biodata Siswa</h5>
                <p><strong>Nama:</strong> <?= $siswa->NamaLengkap ?? '-'; ?></p>
                <p><strong>Email:</strong> <?= $siswa->Email ?? '-'; ?></p>
                <p><strong>No HP:</strong> <?= $siswa->Phone ?? '-'; ?></p>
                <p><strong>Status:</strong> <?= $siswa->NamaStatus ?? '-'; ?></p>
                <?php if (!empty($siswa->NegaraTujuan)): ?>
                    <p><strong>Negara Tujuan:</strong> <?= $siswa->NegaraTujuan; ?></p>
                <?php endif; ?>
                <?php if (!empty($siswa->PerusahaanTujuan)): ?>
                    <p><strong>Perusahaan Tujuan:</strong> <?= $siswa->PerusahaanTujuan; ?></p>
                <?php endif; ?>
            </div>

            <!-- Riwayat Transaksi -->
            <div class="table-responsive">
                <h5 class="font-weight-bold">Riwayat Transaksi</h5>
                <table class="table table-bordered table-hover align-middle">
                    <thead class="thead-light">
                        <tr>
                            <th>Tanggal</th>
                            <th>Jumlah</th>
                            <th>Metode</th>
                            <th>Bukti Transfer</th>
                            <th>Status</th>
                            <th width="150">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($transaksi)): ?>
                            <?php foreach ($transaksi as $t): ?>
                                <tr>
                                    <td><?= date('d-m-Y H:i', strtotime($t->TanggalBayar)); ?></td>
                                    <td>Rp <?= number_format($t->JumlahBayar, 0, ',', '.'); ?></td>
                                    <td><?= $t->MetodeBayar; ?></td>
                                    <td>
                                        <?php if (!empty($t->BuktiTransfer)): ?>
                                            <a href="<?= base_url('uploads/bukti_transfer/'.$t->BuktiTransfer); ?>" target="_blank" class="btn btn-sm btn-secondary">
                                                Lihat
                                            </a>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($t->StatusBayar == 'Pending'): ?>
                                            <span class="badge badge-warning">Pending</span>
                                        <?php elseif ($t->StatusBayar == 'Approved'): ?>
                                            <span class="badge badge-success">Approved</span>
                                        <?php elseif ($t->StatusBayar == 'Rejected'): ?>
                                            <span class="badge badge-danger">Rejected</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($t->StatusBayar == 'Pending'): ?>
                                            <a href="<?= base_url('pembayaran_raftel/approve/'.$t->PembayaranID); ?>" 
                                               class="btn btn-sm btn-success"
                                               onclick="return confirm('Yakin ingin approve pembayaran ini?')">
                                                Approve
                                            </a>
                                            <form action="<?= base_url('pembayaran_raftel/reject/'.$t->PembayaranID); ?>" method="post" style="display:inline;">
                                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Tolak pembayaran ini?')">
                                                    Tolak
                                                </button>
                                            </form>
                                        <?php else: ?>
                                            <button class="btn btn-sm btn-secondary" disabled>Aksi Selesai</button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center text-muted">Belum ada transaksi</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $this->load->view('templates/footer'); ?>
