<!-- Content Wrapper -->
<div id="content-wrapper" class="d-flex flex-column">
  <!-- Main Content -->
  <div id="content">

    <!-- Topbar -->
    <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

      <!-- Sidebar Toggle (Topbar) -->
      <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
        <i class="fa fa-bars"></i>
      </button>

      <!-- Keterangan Halaman Aktif -->
      <h5 class="m-0 font-weight-bold text-primary">
        <?php 
          $page    = $this->uri->segment(1) ? ucfirst($this->uri->segment(1)) : 'Dashboard';
          $subpage = $this->uri->segment(2) ? ucfirst($this->uri->segment(2)) : '';
          echo $page . ($subpage ? " / $subpage" : "");
        ?>
      </h5>

      <!-- Topbar Navbar -->
      <ul class="navbar-nav ml-auto">

        <?php
          // Ambil data user login
          $CI =& get_instance();
          $CI->load->database();

          $user_id   = $CI->session->userdata('UserID') ?? $CI->session->userdata('user_id');
          $username  = $CI->session->userdata('username');
          $role      = $CI->session->userdata('role');
          $role_id   = $CI->session->userdata('role_id');

          $profile_img = base_url('assets/sb-admin2/img/undraw_profile.svg'); // default

          // Kalau siswa, ambil pas foto dari DokumenSiswa
          if ($role === 'Siswa') {
              $siswa = $CI->db->get_where('Siswa', ['UserID' => $user_id])->row();
              if ($siswa) {
                  $foto = $CI->db->get_where('DokumenSiswa', [
                      'UserID'       => $user_id,
                      'JenisDokumen' => 'pas_foto'
                  ])->row();
                  if ($foto && !empty($foto->FilePath)) {
                      $profile_img = base_url('uploads/siswa/' . $user_id . '/' . $foto->FilePath);
                  }
              }
          }
        ?>

        <!-- User Info Dropdown -->
        <li class="nav-item dropdown no-arrow">
          <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" 
             data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <span class="mr-2 d-none d-lg-inline text-gray-600 small">
              <?= $username; ?> (<?= $role; ?>)
            </span>
            <img class="img-profile rounded-circle" src="<?= $profile_img; ?>" width="30" height="30">
          </a>

          <!-- Dropdown -->
          <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in" 
               aria-labelledby="userDropdown">
            <a class="dropdown-item" href="<?= base_url('profile'); ?>">
              <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
              Profile
            </a>

            <?php if (in_array($role_id, [1,2])): // hanya admin & staff ?>
              <div class="dropdown-divider"></div>
              <h6 class="dropdown-header">Pengaturan</h6>
              <a class="dropdown-item" href="<?= base_url('biaya'); ?>">
                <i class="fas fa-money-bill-wave fa-sm fa-fw mr-2 text-gray-400"></i>
                Pengaturan Biaya
              </a>
            <?php endif; ?>

            <div class="dropdown-divider"></div>
            <a class="dropdown-item" href="<?= base_url('auth/logout'); ?>">
              <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
              Logout
            </a>
          </div>
        </li>
      </ul>
    </nav>
    <!-- End of Topbar -->
