<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Invoice Pelatihan</title>
<style>
  @page{ margin: 18mm 14mm 16mm 14mm; }
  body{ font-family: Arial, Helvetica, sans-serif; font-size:12px; color:#222; }

  /* palette */
  .black{ color:#111; }
  .muted{ color:#555; }
  .gold{ background:#d7b354; color:#111; }
  .soft{ background:#f7f7f7; }
  .redband{ background:#e23a3a; height:18px; }

  /* helpers */
  .w-100{ width:100%; }
  .p8{ padding:8px; } .p10{ padding:10px; } .p12{ padding:12px; }
  .mb6{ margin-bottom:6px; } .mb10{ margin-bottom:10px; } .mb14{ margin-bottom:14px; }
  .right{ text-align:right; } .center{ text-align:center; }
  .br{ border:1px solid #e2e2e2; } .br6{ border-radius:6px; }
  .b0 td, .b0 th{ border:none!important; }
  .stamp{ opacity:.85; }

  table{ border-collapse:collapse; width:100%; }
  th, td{ border:1px solid #e5e5e5; padding:8px 10px; vertical-align:top; }
  th{ background:#fafafa; }
  .title{ font-size:28px; font-weight:900; letter-spacing:.5px; }
  .label{ font-weight:bold; }
  .box{ border:1px solid #dcdcdc; border-radius:6px; padding:10px 12px; }

  /* header layout pakai tabel agar aman di dompdf */
  .hdr td{ border:none; }
  .totals td{ padding:6px 10px; }
  .totals .cell{ height:22px; }
</style>
</head>
<body>

<!-- Header atas (logo kiri / judul / logo kanan) -->
<table class="w-100 hdr" cellspacing="0" cellpadding="0">
  <tr>
    <td style="width:25%;">
      <?php if(!empty($logo_left)): ?>
        <img src="<?= $logo_left ?>" style="height:54px;">
      <?php else: ?>
        <div class="label">LPK HSI</div>
      <?php endif; ?>
    </td>
    <td style="width:50%; text-align:center;">
      <div class="title black">INVOICE</div>
    </td>
    <td style="width:25%; text-align:right;">
      <?php if(!empty($logo_right)): ?>
        <img src="<?= $logo_right ?>" style="height:52px;">
      <?php endif; ?>
    </td>
  </tr>
</table>

<div class="redband" style="margin:6px 0 10px 0;"></div>

<!-- Info ringkas -->
<table class="w-100 b0" cellspacing="0" cellpadding="0" style="margin-bottom:8px;">
  <tr>
    <td style="width:50%;">
      <div class="label">INVOICE TO :</div>
      <div style="border-bottom:1px solid #cfcfcf; height:14px; margin-top:8px;"></div>
    </td>
    <td>
      <table class="b0" cellspacing="0" cellpadding="0" style="width:100%;">
        <tr>
          <td class="label" style="width:90px;">Invoice No :</td>
          <td><?= html_escape($invoice_no ?? $no_invoice ?? '-') ?></td>
        </tr>
        <tr>
          <td class="label">Date :</td>
          <td><?= html_escape(($kota ?? 'Cikarang').', '.($tanggal ?? date('Y-m-d'))) ?></td>
        </tr>
      </table>
    </td>
    <td style="width:160px;">
      <div class="label">TOTAL DUE :</div>
      <div class="box" style="margin-top:6px; font-size:14px; font-weight:bold;">
        <?= rupiah((float)($total ?? $subtotal ?? 0)) ?>
      </div>
    </td>
  </tr>
</table>

<!-- Data Penerima + LPK Asal -->
<table class="w-100 br br6" cellspacing="0" cellpadding="0" style="margin-bottom:12px;">
  <tr>
    <td class="b0" style="width:50%; padding:10px 12px;">
      <div class="label mb6">Kepada:</div>
      <div><?= html_escape($nama ?? '-') ?></div>
      <?php if(!empty($email)): ?><div class="muted"><?= html_escape($email) ?></div><?php endif; ?>
      <?php if(!empty($phone)): ?><div class="muted"><?= html_escape($phone) ?></div><?php endif; ?>
    </td>
    <td class="b0" style="padding:10px 12px;">
      <div class="label mb6">LPK ASAL</div>
      <div class="muted"><?= html_escape($lpk_asal ?? '-') ?></div>
    </td>
  </tr>
</table>

<!-- Tabel Termin -->
<table class="w-100" cellspacing="0" cellpadding="0" style="margin-bottom:8px;">
  <thead>
    <tr class="gold">
      <th style="width:28%;">Keterangan</th>
      <th style="width:36%;">Waktu Pembayaran</th>
      <th style="width:36%;">Tagihan</th>
    </tr>
  </thead>
  <tbody>
  <?php
    // default isi 3 termin sesuai mockup
    $rows = $rows ?? [
      ['ket'=>'TERMIN 1','waktu'=>'LOLOS WAWANCARA','tagihan'=>''],
      ['ket'=>'TERMIN 2','waktu'=>'KONTRAK KERJA PERUSAHAAN','tagihan'=>''],
      ['ket'=>'TERMIN 3','waktu'=>'TURUN COE','tagihan'=>''],
    ];
    foreach($rows as $r): ?>
    <tr>
      <td><?= html_escape($r['ket'] ?? '') ?></td>
      <td><?= html_escape($r['waktu'] ?? '') ?></td>
      <td><?= html_escape($r['tagihan'] ?? '') ?></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>

<!-- Baris ucapan + ringkasan pembayaran -->
<table class="w-100 b0" cellspacing="0" cellpadding="0" style="margin-top:10px;">
  <tr>
    <td style="width:60%; vertical-align:top;">
      <div style="font-size:16px; margin-bottom:6px;">ありがとうございます</div>
      <div class="label mb6">Payment Method</div>
      <div class="soft br br6 p10">
        <div><b>Bank Name</b> : <?= html_escape($bank_name ?? 'BNI') ?></div>
        <div><b>Account No</b> : <?= html_escape($account_no ?? '1812954258') ?></div>
        <div><b>Name Account</b> : <?= html_escape($account_name ?? 'Yayasan Hiroshi Seiya Indonesia') ?></div>
      </div>
      <div class="muted" style="margin-top:10px; font-size:11px; line-height:1.5;">
        <b>Terms and Conditions</b><br>
        Pembayaran yang tidak melalui rekening <b>YAYASAN HIROSHI SEIYA INDONESIA</b> dianggap <b>BELUM LUNAS</b> dan
        kami berhak untuk melakukan penagihan kembali atas invoice ini.
      </div>
    </td>
    <td style="vertical-align:top;">
      <table class="w-100 br br6 totals" cellspacing="0" cellpadding="0">
        <tr>
          <td class="label" style="width:110px;">Sudah Bayar :</td>
          <td class="cell right"><?= rupiah((float)($sudah_bayar ?? 0)) ?></td>
        </tr>
        <tr>
          <td class="label">Belum Bayar :</td>
          <td class="cell right"><?= rupiah((float)($belum_bayar ?? ($total ?? 0))) ?></td>
        </tr>
        <tr>
          <td class="label">Total :</td>
          <td class="cell right" style="font-weight:bold;"><?= rupiah((float)($total ?? 0)) ?></td>
        </tr>
      </table>

      <!-- stempel + ttd -->
      <div style="margin-top:18px; position:relative; height:110px;">
        <?php if(!empty($stempel_url)): ?>
          <img src="<?= $stempel_url ?>" class="stamp" style="position:absolute; left:6px; top:0; height:90px;">
        <?php endif; ?>
        <?php if(!empty($ttd_url)): ?>
          <img src="<?= $ttd_url ?>" style="position:absolute; right:0; top:18px; height:60px;">
        <?php endif; ?>
        <div style="position:absolute; right:0; bottom:0; text-align:right;">
          <div class="label">Pimpinan LPK Hiroshi Seiya</div>
        </div>
      </div>
    </td>
  </tr>
</table>

<!-- footer merah -->
<div class="redband" style="margin-top:10px;"></div>

</body>
</html>
